/* missile.m,
 *
 * Missiles are ally secondary weapon projectiles.
 */

#include <math.h>
#include "common.h"
#include "debris/smoke.h"
#include "projectiles/missile.h"
#include "seborrhea/seborrhea.h"


#define SMOKE_DELAY	2


@implementation Missile
- init
{
    [super init];

    health = 5;
    speed = 6.0;
    angle = -M_PI_2;

    sprite = (Sebum<SebImage> *)[base_sebum getSebumByName:"weapon/missile"];
    w = [sprite width];
    h = [sprite height];
    rotatable_sprite = YES;

    return self;
}

- (int) update
{
    if (smoke_tics-- <= 0) {
	spawn_debris([Smoke class], x, y, MEDIUM_LAYER);
	smoke_tics = SMOKE_DELAY;
    }
    return [super update];
}
@end

/*------------------------------------------------------------*/

void fireMissile(double x, double y, int level, int *reload, int pid)
{
#define SPAWN_ALLY_PROJ(class,x,y,theta)		[[(AllyProjectile *)spawn_projectile(class,x,y,YES) setAngle:theta] setParentID:pid]

    Class proj = [Missile class];

    /* Level 0: 2 x 5 hp/shot * 50/50 shots/sec = 10.0 hp/sec.
       Level 1: 3 x 5 hp/shot * 50/50 shots/sec = 15.0 hp/sec.
       Level 2: 4 x 5 hp/shot * 50/50 shots/sec = 20.0 hp/sec.
    */

    y -= 10;
    if (level == 0) {
        SPAWN_ALLY_PROJ(proj, x-10, y, deg2rad(100.0));
        SPAWN_ALLY_PROJ(proj, x+10, y, deg2rad(80.0));
    } 
    elif (level == 1) {
        SPAWN_ALLY_PROJ(proj, x-10, y, deg2rad(110.0));
	SPAWN_ALLY_PROJ(proj, x   , y, deg2rad(90.0));
	SPAWN_ALLY_PROJ(proj, x+10, y, deg2rad(70.0));
    }
    else {
        SPAWN_ALLY_PROJ(proj, x-10, y, deg2rad(120.0));
        SPAWN_ALLY_PROJ(proj, x- 3, y, deg2rad(100.0));
        SPAWN_ALLY_PROJ(proj, x+ 3, y, deg2rad(80.0));
        SPAWN_ALLY_PROJ(proj, x+10, y, deg2rad(60.0));
    }

    *reload = 50;

#undef SPAWN_ALLY_PROJ
}
