/* maser.m,
 *
 * Masers are enemy lasers.  They are slower, smaller, do 1 damage and
 * die on impact.  So they are really, nothing like (player) lasers.
 * They are also further away from microwaves than lasers are...
 */

#include "common.h"
#include "projectiles/maser.h"
#include "seborrhea/seborrhea.h"


static SebFile *maser_sebum;


@implementation Maser
+ initialize { REGISTER_PROJECTILE(self); return self; }
+ derive_loadDataProjectile(maser_sebum, "data/proj-maser");
+ derive_shutdownProjectile(maser_sebum);

- init
{
    [super init];

    speed = 10.0;

    sprite = (Sebum<SebImage> *)[maser_sebum getSebumByName:"maser"];
    w = [sprite width];
    h = [sprite height];

    return self;
}
@end
