/* fireball.m,
 *
 * Fireballs are small, slow (but otherwise just as dangerous) enemy
 * projectiles.  They have an animation on impact.
 */

#include "common.h"
#include "debri.h"
#include "projectiles/fireball.h"
#include "seborrhea/container-animation.h"


static SebFile *fireball_sebum;


@interface FireballDeath: AnimatedDebriNoLoop
@end

/*------------------------------------------------------------*/

@implementation Fireball
+ initialize { REGISTER_PROJECTILE(self); return self; }
+ derive_loadDataProjectile(fireball_sebum, "data/proj-fireball");
+ derive_shutdownProjectile(fireball_sebum);

- init
{
    [super init];

    speed = rnd(12, 24) / 10.0;

    sprite = [fireball_sebum getSebumByName:"fireball"];
    w = [sprite width]-2;
    h = [sprite height]-2;

    return self;
}

- (void) die
{
    spawn_debris([FireballDeath class], x, y, HIGH_LAYER);
    [super die];
}
@end

/*------------------------------------------------------------*/

@implementation FireballDeath
- init
{
    [super init];

    speed = 0.0;
    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)[fireball_sebum getSebumByName:"death"]];

    return self;
}
@end
