/* dumbfire.m,
 *
 * Dumbfire missiles have a short hangtime before launching off.
 * Enemy projectiles.
 */

#include <math.h>
#include "common.h"
#include "debris/smoke.h"
#include "projectiles/dumbfire.h"
#include "seborrhea/seborrhea.h"


@implementation DumbfireLeft
/* No need to to register self (yet). */
- init
{
    [super init];

    speed = 0.0;		/* Increased up to 7.0 */

    sprite = (Sebum<SebImage> *)[base_sebum getSebumByName:"weapon/missile"];
    w = [sprite width];
    h = [sprite height];
    rotatable_sprite = YES;

    xv = -2.0;
    yv =  5.0;

    return self;
}

- (int) update
{
    if (health <= 0)
	return THING_DEAD;
    else if (drop_tics < 15) {
	drop_tics++;
	x += xv*cos(angle) + yv*cos(angle+M_PI_2);
	y -= xv*sin(angle) + yv*sin(angle+M_PI_2);

	xv += 0.2;
	yv *= 0.7;

	return THING_NORMAL;
    }
    else {
	double xx = cos(angle)*w/2;
	double yy = sin(angle)*w/2;
	spawn_debris([Smoke class], x-xx, y+yy, MEDIUM_LAYER);

	if (drop_tics < 25) {
	    drop_tics++;
	    speed += 0.35;
	    recalculate_velocity = YES;
	}
    }
    return [super update];
}
@end
