/* -*- ObjC -*- */
#ifndef __included_projectile_h
#define __included_projectile_h

#include "thing.h"
#include "projectiles/all-projs.h"

#define derive_loadDataProjectile(sebum,dir)				\
	(BOOL) loadData							\
	{ sebum = [SebFile new]; return [sebum loadSebumDirectory:dir]; }

#define derive_shutdownProjectile(sebum)				\
	(void) shutdown							\
	{ FREE_SEBFILE(sebum); }

/*--------------------------------------------------------------*/

struct BITMAP;

@interface Projectile: Thing <DetectsCollision>
{
    /* Location & movement */
    double angle, speed;
    BOOL rotatable_sprite;
    double xv, yv;		/* Optimisation stuff. */
    BOOL recalculate_velocity;

    BOOL alliance;		/* yes = player, no = enemy. */
}
        /* Initialization. */
- (id) setAlliance:(BOOL)good;
- (id) setAngle:(double)theta;
- (void) die;

	/* Collisions. */
+ (int) collisionLists;
+ (enum DAMAGE_TYPE) damageType;
- (int) damage;
- (int) parentID;
@end

@interface AllyProjectile: Projectile
{
    unsigned int parent_id;
}
- (id) setParentID:(int)n;
@end

void draw_projectiles(BITMAP *dest);
void update_projectiles(void);

Projectile *spawn_projectile(Class class, double x, double y, BOOL is_goodie);

void projectile_init(void);
void projectile_shutdown(void);

#endif
