/* pregen-circles.m,
 *
 * Pregenerated circles for speed.  A big, fat file, which also makes
 * the executable fat.  Used mainly for nukes.
 */

#include <allegro.h>
#ifndef NO_FBLEND
# include "fblend/include/fblend.h"
#endif
#include "pregen-circles.h"


struct span_list { 
    unsigned int h; 
    unsigned int *half_width; 
};
#include "pregen-circles.inc"


/* Draw a normal circle. */
void pregen_circle(BITMAP *dest, int x, int y, int r, int c)
{
    struct span_list *circle;
    unsigned int j;
    int x1, x2;

    r = MID(MIN_CIRCLE_RADIUS, r, MAX_CIRCLE_RADIUS);
    circle = circles[r];
    y -= circle->h / 2;

    /* Top-most row. */
    x1 = x - circle->half_width[0];
    x2 = x + circle->half_width[0];
    hline(dest, x1, y, x2, c);

    for (j = 1, y++; j < circle->h; j++, y++) {
	x1 = x - circle->half_width[j];
	x2 = x - circle->half_width[j - 1];
	hline(dest, x1, y, x2, c);

	x1 = x + circle->half_width[j - 1];
	x2 = x + circle->half_width[j];
	hline(dest, x1, y, x2, c);
    }

    /* Bottom-most row. */
    x1 = x - circle->half_width[circle->h - 1];
    x2 = x + circle->half_width[circle->h - 1];
    hline(dest, x1, y, x2, c);
}


/* Draw a circle with the "add" blender, and use FBlend. */
void pregen_circlefill_add(BITMAP *dest, int x, int y, int r, int c, int a)
{
    struct span_list *circle;
    unsigned int j;

    r = MID(MIN_CIRCLE_RADIUS, r, MAX_CIRCLE_RADIUS);
    circle = circles[r];

#ifndef NO_FBLEND
    for (j = 0, y -= circle->h/2; j < circle->h; j++, y++) {
	fblend_rect_add(dest, x-circle->half_width[j], y,
			2*circle->half_width[j], 1, c, a);
    }
#else					/* Normal Allegro routines. */
    drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
    set_add_blender(0xff, 0xff, 0xff, a);
    for (j = 0, y -= circle->h/2; j < circle->h; j++, y++) {
	hline(dest, x-circle->half_width[j], y,
	      x+circle->half_width[j], c);
    }
    drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
#endif					/* End: NO_FBLEND */
}
