/* -*- ObjC -*- */
#ifndef __included_player_h
#define __included_player_h

#include "linklist.h"
#include "unit.h"

#define MAX_PLAYERS		2
#define FIRST_PRIMARY_WEAPON	PRIMARY_WEAPON_LASER
#define LAST_PRIMARY_WEAPON	PRIMARY_WEAPON_VULCAN
#define FIRST_SECONDARY_WEAPON	SECONDARY_WEAPON_HOMING_MISSILE
#define LAST_SECONDARY_WEAPON	SECONDARY_WEAPON_PINK_ORANGE_RED
#define FIRST_TERTIARY_WEAPON	TERTIARY_WEAPON_ROBOTS
#define LAST_TERTIARY_WEAPON	TERTIARY_WEAPON_SATELLITE

enum WEAPON_GROUP {
    PRIMARY_WEAPON = 0,
    SECONDARY_WEAPON,
    TERTIARY_WEAPON,
    NUM_WEAPONS
};

typedef enum WEAPON_GROUP weapon_group_t;

enum PRIMARY_WEAPON {
    PRIMARY_WEAPON_LASER = 0,
    PRIMARY_WEAPON_TOOTHPASTE,
    PRIMARY_WEAPON_VULCAN,
    NUM_PRIMARY_WEAPONS
};

enum SECONDARY_WEAPON {
    SECONDARY_WEAPON_NONE = -1,
    SECONDARY_WEAPON_HOMING_MISSILE,
    SECONDARY_WEAPON_MISSILE,
    SECONDARY_WEAPON_PINK_ORANGE_RED,
    NUM_SECONDARY_WEAPONS
};

enum TERTIARY_WEAPON {
    TERTIARY_WEAPON_NONE = -1,
    TERTIARY_WEAPON_ROBOTS,
    TERTIARY_WEAPON_SATELLITE
};

@class SebAnimation;
@class Player;

@protocol PlayerChild
- (id) setParent:(Player *)p;
@end

@interface Player: Unit <OwnsChildren>
{
    double xv, yv;		/* This is really only for dying and determining which animation to use. */

    /* Weapons. */
    int weapon[NUM_WEAPONS];
    int weapon_level[NUM_WEAPONS];
    int weapon_tics[NUM_WEAPONS];
    int weapon_barrel;			/* For PinkOrangeRed. */

    List *children_list;		/* Robots and Satellites. */

    /* This is for 1 press = 1 shot feel. */
    int fire_tics;
    BOOL fire_was_down;

    /* Animations. */
    SebAnimation *anims[3];		/* NUM_ORIENTATIONS */
    SebAnimation *animation;		/* Current one in use. */

    /* Stupid. */
    int adrenaline_meter;

    int invulnerable_tics;
    int pid;
}
- (void) drawHealth:(BITMAP *)bmp;
- (void) increaseVelocity:(double)xv_ :(double)yv_;
- (void) zoom;
- (void) openFire;
- (void) haltFire;
- (BOOL) isFiring;
- (void) setWeapon:(weapon_group_t)n to:(int)new_weapon;
- (int) weaponType:(weapon_group_t)n;
- (void) increaseScore:(int)n;
- (void) incrementKillsFrom:(double)x_ :(double)Y_;
- (int) playerID;
@end

@interface Player2: Player
@end

extern Player *player[MAX_PLAYERS];
extern unsigned int num_players;

#endif
