/* -*- ObjC -*- */
#ifndef __included_newmenu_h
#define __included_newmenu_h

#include <objc/Object.h>
#include "seborrhea/seborrhea.h"

#define MENU_FONT_NAME		"fonts/sui-generis-bold"
#define MENU_FONT_SIZE		30
#define MENU_SPEED		20
#define MENU_SECONDS		MENU_SPEED
#define MENU_MUSIC_DIRNAME	"music/menu"
#define HOTKEY_MENU		-1

typedef struct {
    const char *text;
    int hotkey;
    int slider_val, slider_max;	/* <= 0 to denote non-slider. */
    int r, g, b;
    void (*action)(void);
} menuitem_t;

typedef struct {
    menuitem_t menuitem[6];
    int selected_item;
    int n_menuitems;
} menu_t;

extern BOOL emergency_exit;
extern SebFile *menu_sebum;
extern volatile int counter;

void play_back_sound(void);
void play_bing_sound(void);
void play_okay_sound(void);
BOOL menu_select_previous(void);
BOOL menu_select_next(void);
BOOL menu_select_left(void);
BOOL menu_select_right(void);
void selected_item_colour(int *r, int *g, int *b, int t);

void play(const char *level_list[], unsigned int num_levels,
	  BOOL check_highscore, BOOL prefix_with_data_dir);

void menu_common_update(void);
void do_newmenu(void);

#endif
