#!/bin/bash
# 2004-04-17
# 2004-12-10: When called w/ an argument, that argument is used for the backup name.

if [ "$(basename $(pwd))" != "raid" ]; then
    echo "You must run this from the root directory of RAID"
    echo "and it must be called 'raid'.  Aborting..."
    exit 1
fi

if [ $# == 0 ]; then
    BKNAME="raid-`date +'%Y%m%d'`"
else
    BKNAME="raid-$1"
fi
BKTGZ="${BKNAME}.tar.gz"

cd ..
if [ -e "$BKNAME" ] ; then
    echo "../$BKNAME exists, aborting..."
    exit 1
fi
if [ -e "$BKTGZ" ]; then
    echo "../$BKTGZ exists, aborting..."
    exit 1
fi

echo "--- Copying current copy to temp dir ---"
cp -rp raid "$BKNAME"

# inside $BKNAME
echo "--- Cleaning up a bit ---"
( cd "$BKNAME" ;
    make cleaner strip ;
    rm -f core.* ;
    rm -f egg/explosion/*.tga ;
)
# outside $BKNAME

echo "--- Tarring up ---"
tar zcf "$BKTGZ" "$BKNAME"
if [ ! -e "$BKTGZ" ]; then
    echo "Error creating $BKTGZ, aborting..."
    exit 1
fi

echo "--- Deleting temp dir ---"
rm -r "$BKNAME"

echo "Done."
