; install.nsi
;
; Put the main program inside ./dist/
;

;------------------------------------------------------------
; The name of the project, setup filename and default installation directory.

Name "Raid'em"
OutFile "raid-0.2-setup.exe"
InstallDir $PROGRAMFILES\Raid

;------------------------------------------------------------
; Pages

Page directory
Page instfiles

UninstallText "This will uninstall Raid'em.  maps/*.map and data/*.zip will be deleted.  If you want to keep anything (like this wonderful game), abort now.  Otherwise, click Uninstall."
UninstPage uninstConfirm
UninstPage instfiles

;------------------------------------------------------------
; Installer

Section "Installer"
  ; This is shit.
  MessageBox MB_YESNO "Install for all users?" IDYES inst_all IDNO skip
  inst_all:
  SetShellVarContext all
  skip:

  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; The game, and an uninstaller.
  File /r dist\*.*
  WriteUninstaller "$INSTDIR\uninstall.exe"

  ; Shortcuts
  CreateDirectory "$SMPROGRAMS\Raid'em"
  CreateShortCut "$SMPROGRAMS\Raid'em\Raid'em.lnk" "$INSTDIR\raid.exe"
  CreateShortCut "$SMPROGRAMS\Raid'em\Raid'em (windowed).lnk" "$INSTDIR\raid.exe" "--windowed"
  CreateShortCut "$SMPROGRAMS\Raid'em\REdit.lnk" "$INSTDIR\raid.exe" "--edit --width 800 --height 600"
  CreateShortCut "$SMPROGRAMS\Raid'em\Readme.lnk" "$INSTDIR\README.txt"
  CreateShortCut "$SMPROGRAMS\Raid'em\Uninstall Raid'em.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\Raid'em\Explore Raid'em directory.lnk" "$INSTDIR"
SectionEnd

;------------------------------------------------------------
; Uninstaller

Section "Uninstall"
  ; Dodgy way to check if installed for single/all users.
  IfFileExists "$SMPROGRAMS\Raid'em\*.lnk" skip
  SetShellVarContext all
  skip:

  ; Start Menu items.
  Delete "$SMPROGRAMS\Raid'em\*.lnk"
  RMDir "$SMPROGRAMS\Raid'em"

  ; Delete stuff.
  Delete "$INSTDIR\music\level2\=ignore"
  RMDir  "$INSTDIR\music\level2"
  Delete "$INSTDIR\music\level1\=ignore"
  RMDir  "$INSTDIR\music\level1"
  Delete "$INSTDIR\music\menu\=ignore"
  RMDir  "$INSTDIR\music\menu"
  RMDir  "$INSTDIR\music"
  Delete "$INSTDIR\maps\*.map"
  RMDir  "$INSTDIR\maps"
  Delete "$INSTDIR\data\*.zip"
  RMDir  "$INSTDIR\data"
  Delete "$INSTDIR\raid.exe"
  Delete "$INSTDIR\uninstall.exe"
  Delete "$INSTDIR\ChangeLog"
  Delete "$INSTDIR\ChangeLog-0.1"
  Delete "$INSTDIR\joystick.cfg"
  Delete "$INSTDIR\keyboard.cfg"
  Delete "$INSTDIR\joystick.cfg.example"
  Delete "$INSTDIR\keyboard.cfg.example"
  Delete "$INSTDIR\INSTALLING.txt"
  Delete "$INSTDIR\LICENCE.txt"
  Delete "$INSTDIR\README.txt"
  Delete "$INSTDIR\damages.txt"
  Delete "$INSTDIR\scores.txt"
  Delete "$INSTDIR\libpng12.dll"
  Delete "$INSTDIR\pthreadGC1.dll"
  Delete "$INSTDIR\zlib1.dll"
  RMDir  "$INSTDIR"
SectionEnd

Function un.onGUIEnd
  ; If instdir still exists, open it.
  IfFileExists "$INSTDIR\*.*" +1 skip
  ExecShell "open" "$INSTDIR"
  skip:
FunctionEnd

