/* -*- ObjC -*- */
#ifndef __included_map_h
#define __included_map_h

#include <allegro.h>
#include <objc/Object.h>
#include "seborrhea/seborrhea.h"

#define TILE_W			64
#define TILE_H			64
#define MAP_W_TILES		6
#define DEFAULT_SCROLL_RATE	-0.9

@interface Map: Object
{
    int map_length;
    double current_scroll_rate, desired_scroll_rate;
    double offset_x, offset_y;

    Sebum<SebImage> ***base_tiles;
    Sebum<SebImage> ***parallax_tiles;

    char *music_dirname;

    BOOL spawn_stars;

    int pixels_to_stop_scrolling;
}
- (id) reset;
- (id) resize:(int)new_length;
- (void) drawParallaxLayer:(BITMAP *)dest :(BOOL)parallaxiness;
- (void) drawTiles:(BITMAP *)dest;
- (int) length;

- (double) offsetX;
- (double) offsetY;
- (void) setOffsetX:(double)offset_x_ Y:(double)offset_y_;

- (double) scrollRate;
- (void) setScrollRate:(double)new_rate :(BOOL)absolute;

- (void) update;
- (const char *) musicDirname;

- (id) setStars:(BOOL)want_stars;
- (BOOL) stars;

	/* For use in map editor only! */
- (void) saveTo:(PACKFILE *)fp;
- (void) loadFrom:(PACKFILE *)fp version:(const char *)version;
- (BOOL) setTileAt:(Sebum<SebImage> ***)tiles :(int)x :(int)y to:(Sebum<SebImage> *)tile;
- (BOOL) setParallaxTileAt:(int)x :(int)y to:(Sebum<SebImage> *)tile;
- (BOOL) setTileAt:(int)x :(int)y to:(Sebum<SebImage> *)tile;
- (void) pan:(int)deltay;
- (void) setMusicDirname:(const char *)fn;
@end

extern Map *current_map;
extern double offsetX, offsetY;	/* current map's offsets, for convenience. */

#endif
