/* quit.m,
 */

#include <allegro.h>
#include "gui/gui.h"
#include "gui/gui-widgets.h"
#include "map-editor/quit.h"
#include "music.h"


static Frame *quit_frame;
static void make_quit_frame(void);


BOOL do_quit_dialog(void)
{
    int msg = 0;
    BITMAP *dbuf;

    if (!quit_frame)
	make_quit_frame();

    dbuf = create_bitmap(SCREEN_W, SCREEN_H);
    [quit_frame receiveMessage:MSG_REDRAW :0];

    while ((msg != MSG_OK) && (msg != MSG_CANCEL)) {
	msg = [quit_frame update];
	clear_to_color(dbuf, makecol(0xa0, 0xa0, 0xa0));
	[quit_frame draw:dbuf];
	poll_music();
    }

    if (dbuf)
	destroy_bitmap(dbuf);

    return (msg == MSG_OK) ? YES : NO;
}





/*------------------------------------------------------------*/
/* Yucky.  Stay away.                                         */
/*------------------------------------------------------------*/





void make_quit_frame(void)
{
    VPackingBox *vbox = [[[VPackingBox new] setHPadding:20 VPadding:20] setChildSpacing:10];

    [vbox insertWidget:[[[Label new]
			    setDrawBackground:NO]
			   setText:"Really quit REdit?"]];

    {
	HPackingBox *hbox = [HPackingBox new];
	
	[hbox insertWidget:[[OkButton new] setText:"Yes"]];
	[hbox insertWidget:[[CancelButton new] setText:"No"]];

	[vbox insertWidget:hbox];
    }

    quit_frame = [[[Frame new] setChild:vbox]
		     setX:SCREEN_W/2 - 150 Y:SCREEN_H/2 - 40 W:300 H:80];
}
