/* -*- ObjC -*- */
#ifndef __included_palette_proc_h__
#define __included_palette_proc_h__

#include "gui/gui-widgets.h"
#include "map-editor/map-proc.h"
#include "map-editor/redit.h"

#define MSG_CHANGED_EDITING_MODE	100
#define MSG_RESELECT			101

@interface MapPalette: Widget
{
    int scrolly[NUM_MODES];
    int lmb_item[NUM_MODES];
    int rmb_item[NUM_MODES];
    int (*pushed_proc)(Widget *widget, int msg, int data);

    MapProc *map_proc;
    Label *label;

    VScrollbar *vscrollbar;

    /* Lazy. */
    int items_per_row, items_per_col;
}
- (id) setMapProcWidget:(MapProc *)widget;
- (id) setLabelWidget:(Label *)widget;
- (void) setSelectedItemLabel;
@end

#endif
