/* -*- ObjC -*- */
#ifndef __included_map_proc_h
#define __included_map_proc_h

#include "gui/gui-widgets.h"
#include "linklist.h"
#include "map-editor/redit.h"
#include "map.h"
#include "seborrhea/seborrhea.h"

@class Unit;

@interface MapProc: Widget
{
    /* Scrollbars. */
    HScrollbar *hscrollbar;
    VScrollbar *vscrollbar;

    Map *the_map;

    /* The tile/unit to place. */
    Sebum<SebImage> *lmb_tile, *rmb_tile;
    Class selected_ground_class;
    Class selected_air_class;

    /* Tagged units. */
    List *tagged_list;

    BOOL snap_to_grid;
    int last_mouse_x, last_mouse_y;     /* Where the mouse was pressed. */
}
- (void) loadMap:(const char *)filename;
- (void) drawGrid:(BITMAP *)bmp;
- (void) deleteUnit:(Unit *)unit;
- (void) setSelectedLMBItem:(int)data;
- (void) setSelectedRMBItem:(int)data;
- (Class) getSelectedUnitClass;
@end

Unit *findUnitAt(double x, double y);

#endif
