/* help.m,
 */

#include <allegro.h>
#include "gui/gui-widgets.h"
#include "gui/gui.h"
#include "map-editor/help.h"
#include "music.h"


static Frame *make_help_frame(void);


void do_help_dialog(void)
{
    BITMAP *dbuf = create_bitmap(SCREEN_W, SCREEN_H);
    Frame *help_frame = make_help_frame();

    [help_frame receiveMessage:MSG_REDRAW :0];
    while ([help_frame update] != MSG_OK) {
	clear_to_color(dbuf, makecol(0xa0, 0xa0, 0xa0));
	[help_frame draw:dbuf];

	poll_music();
    }

    [help_frame free];
    if (dbuf)
	destroy_bitmap(dbuf);
}





/*--------------------------------------------------------------*/
/* Yucky.  Stay away.						*/
/*--------------------------------------------------------------*/





static Frame *make_help_frame(void)
{
    Frame *help_frame;

    HPackingBox *hbox = [[[[HPackingBox new] 
			      setMaxHeight:400]
			     setHPadding:20 VPadding:20] setChildSpacing:20];

    {					/* Left column. */
	VPackingBox *grouper = [[VPackingBox new] setChildSpacing:40];

	{				/* Global commands. */
	    VPackingBox *vbox = [[VPackingBox new] setMaxHeight:20*9];
	    [vbox insertWidget: [[Label new] setText:"GLOBAL COMMANDS"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"F1 - Display this screen"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"F2 - Play music"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"F3 - Pick music for level"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"F4 - Toggle stars"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"L  - Load map"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"S  - Save map"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"R  - Resize map"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"P  - Pan map"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"Spacebar - Toggle grid snap"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"Q  - Quit"]];
	    [grouper insertWidget:vbox];
	}

	[hbox insertWidget:grouper];
    }

    {					/* Right column. */
	VPackingBox *grouper = [[VPackingBox new] setChildSpacing:40];

	{				/* Tile commands. */
	    VPackingBox *vbox = [[VPackingBox new] setMaxHeight:20*3];
	    [vbox insertWidget: [[Label new] setText:"TILE MODE COMMANDS"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"LMB - Place tile (yellow)"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"RMB - Place tile (green)"]];
	    [grouper insertWidget:vbox];
	}

	{				/* Unit commands. */
	    VPackingBox *vbox = [[VPackingBox new] setMaxHeight:20*9];
	    [vbox insertWidget: [[Label new] setText:"UNIT MODE COMMANDS"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"LMB - Place/select/move unit"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"RMB - Remove unit"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"    - Angle units towards cursor"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"A   - Set activation line"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"D   - Set travel distance"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"G   - Set group number"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"1-5 - Toggle powerups to spawn"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"6   - Toggle 2-player-mode-only"]];
	    [vbox insertWidget: [[[[Label new] setTextJustification:LEFT_JUSTIFY] setDrawBackground:NO] setText:"Keypad - Move/rotate units"]];

	    [grouper insertWidget:vbox];
	}

	[grouper insertWidget: [[[[OkButton new] setMaxWidth:150] setMaxHeight:50] setText:"OK"]];
	[hbox insertWidget:grouper];
    }

    help_frame = [Frame new];
    [[help_frame setChild:hbox] setX:10 Y:10 W:SCREEN_W-20 H:SCREEN_H-20];
    return help_frame;
}
