/* -*- ObjC -*- */
#ifndef __included_input_h
#define __included_input_h

#include <objc/Object.h>

#ifdef WINFF
# include "allegff/winff.h"
#endif

#ifndef MAX_PLAYERS
# define MAX_PLAYERS	2
#endif

#define NUM_FIRE_BUTTONS	2

enum RAID_KEY {
    RAID_KEY_UP,
    RAID_KEY_DOWN,
    RAID_KEY_LEFT,
    RAID_KEY_RIGHT,
    RAID_KEY_START,
    RAID_KEY_MENU,
    RAID_KEY_FIRE,
    NUM_RAID_KEYS,
    RAID_KEY_FIRE2		/* Hack. */
};

typedef enum RAID_KEY raid_key_t;

@interface InputController: Object
{
    BOOL pressed[NUM_RAID_KEYS];
    BOOL was_pressed[NUM_RAID_KEYS];
    int repeat_tics[NUM_RAID_KEYS];
    BOOL auto_repeat[NUM_RAID_KEYS];
}
- (BOOL) seekInFile:(const char *)fn :(FILE *)fp For:(const char *)seekee;
- (void) poll;
- (void) pollUpdatePressed;
- (BOOL) pressed:(raid_key_t)k;
- (BOOL) held:(raid_key_t)k;
- (BOOL) released:(raid_key_t)k;
- (void) setKey:(raid_key_t)k To:(int)k_;
- (int) getKey:(raid_key_t)k;
@end

@interface KeyboardController: InputController
{
    int up, down, left, right;
    int fire[NUM_FIRE_BUTTONS];
}
- initWithConfigFile:(FILE *)fp :(const char *)section;
@end

@interface JoystickController: InputController
{
    int joy_num;
    int x_stick, x_axis;
    int y_stick, y_axis;
    int start_b, menu_b;

    int hthresh, vthresh;

    BOOL ignore_stick[MAX_JOYSTICK_STICKS];

#ifdef WINFF
    FFEFFECT *ff_player_hurt;
    FFEFFECT *ff_player_dying;
#endif
}
- initWithJoystickNumber:(int)n ConfigFile:(FILE *)fp;
- (int) joystickNumber;
- (int) xPosition;
- (int) yPosition;

#ifdef WINFF
- (void) rumbleHurt;
- (void) rumbleDying;
#endif
@end

/*--------------------------------------------------------------*/

typedef struct {
    KeyboardController *keyboard;
    JoystickController *joystick;
} player_controls_t;

extern KeyboardController *menu_keyboard_controls;
extern JoystickController *joystick_controller[MAX_JOYSTICKS];
extern player_controls_t player_controls[MAX_PLAYERS];
extern BOOL joy_enabled;

#ifdef WINFF
# define rumble_pad_for_player_hurt(pl)		[player_controls[pl].joystick rumbleHurt]
# define rumble_pad_for_player_dying(pl)	[player_controls[pl].joystick rumbleDying]
#endif

void do_input(void);
void poll_raid_keys(int n_players);
BOOL start_pressed(void);
BOOL start_released(void);
BOOL retry_released(void);
BOOL join_pressed(void);
BOOL okay_released(void);
BOOL menu_released(void);

int input_init(void);
void input_shutdown(void);

#endif

