/* init.m,
 *
 * Some common initialisation stuff.
 */

#include <allegro.h>
#include <stdio.h>
#include "colour-conv.h"
#include "common.h"
#include "music.h"
#include "seborrhea/font-glyphkeeper.h"
#include "seborrhea/seborrhea-allegro.h"
#include "sound.h"
#include "tile.h"
#include "units/all-units.h"


BOOL fullscreen;


static int try_gfx_mode(int gfx_mode, int w, int h, int depth)
{
    set_color_depth(depth);

#ifdef ALLEGRO_VRAM_SINGLE_SURFACE
    if (set_gfx_mode(gfx_mode, w, h, w, h*3) == 0)
	return 1;
    if (set_gfx_mode(gfx_mode, w, h, w, h*2) == 0)
	return 1;
#endif

    return (set_gfx_mode(gfx_mode, w, h, 0, 0) == 0);
}

int switch_gfx_mode(int gfx_mode, int w, int h, int bpp)
{
    if (bpp <= 0) {
	if (screen)
	    bpp = bitmap_color_depth(screen);
	else
	    bpp = desktop_color_depth();
    }

    if (bpp > 0 && try_gfx_mode(gfx_mode, w, h, bpp));
    elif (try_gfx_mode(gfx_mode, w, h, 16));
    elif (try_gfx_mode(gfx_mode, w, h, 32));
    elif (try_gfx_mode(gfx_mode, w, h, 15));
    elif (try_gfx_mode(gfx_mode, w, h, 24));
    else {
	allegro_message("Error setting any high-colour video mode.\n%s.\n", allegro_error);
	return -1;
    }

#ifndef NO_FBLEND
    if (screen && bitmap_color_depth(screen) == 24)
	allegro_message("Warning: Resorting to 24bpp.  Blending effects will not show correctly.\nCompile with NO_FBLEND to use normal Allegro blending routines.");
#endif

    return 0;
}

static int auto_pick_gfx_mode(int gfx_mode, int w, int h, int bpp)
{
    if (gfx_mode == GFX_AUTODETECT) {
	if (switch_gfx_mode(GFX_AUTODETECT_FULLSCREEN, w, h, bpp) < 0) {
	    /* Fullscreen failed.  Try windowed mode instead. */
	    gfx_mode = GFX_AUTODETECT_WINDOWED;
	}
	else {
	    fullscreen = YES;
	    return 0;
	}
    }

    if (switch_gfx_mode(gfx_mode, w, h, bpp) < 0)
	return -1;

    fullscreen = (gfx_mode == GFX_AUTODETECT_WINDOWED) ? NO : YES;
    return 0;
}

int raid_init(int gfx_mode, int w, int h, int bpp, BOOL mute)
{
    allegro_init();
    install_timer();

    if (auto_pick_gfx_mode(gfx_mode, w, h, bpp) < 0)
	return -1;
    else {			/* Display GFX capabilities. */
	if (gfx_capabilities & GFX_CAN_SCROLL)
	    printf("Can use page-flipping.\n");
	if (gfx_capabilities & GFX_CAN_TRIPLE_BUFFER)
	    printf("Can use triple buffering.\n");
    }

    if (mute) {
	sound_vol = 0;
	music_vol = 0;
    }
    else {
	sound_init();
	music_init();
    }

    seborrhea_allegro_init();
    /* sebfont_alfont_init(); */
    sebfont_glyphkeeper_init();
    tiles_init();

    set_colour_conversion_keep_alpha();
    base_sebum = [SebFile new];
    if (not [base_sebum loadSebumDirectory:"data/base"]) {
	base_sebum = nil;
	fprintf(stderr, "Error loading base datafiles.\n");
	return -1;
    }
    set_color_conversion(COLORCONV_TOTAL);

    /* XXX: should be loaded as required. */
    if (not load_tiles_sebum("data/tiles-desert"))
	fprintf(stderr, "Error loading desert datafiles.\n");
    if (not load_tiles_sebum("data/tiles-space"))
	fprintf(stderr, "Error loading space datafiles.\n");
    if (not load_tiles_sebum("data/tiles-water"))
	fprintf(stderr, "Error loading water datafiles.\n");

    make_all_units_tables();

    set_display_switch_mode(SWITCH_AMNESIA);

    return 0;
}

void raid_shutdown(void)
{
    shutdown_special_units();
    FREE_SEBFILE(base_sebum);

    tiles_shutdown();
    sebfont_glyphkeeper_shutdown();
    music_shutdown();
    sound_shutdown();
}
