/* -*- ObjC -*- */
#ifndef __included_widget_scrollbar_h
#define __included_widget_scrollbar_h

#include "gui-widgets.h"
#include "widget-slider.h"

#define SCROLLBAR_NUM_BUTTONS			4

@interface Scrollbar: Widget <Container>
{
    Button *button[SCROLLBAR_NUM_BUTTONS];
    Slider *slider;
    int slider_message;
}
/* Button related. */
- (int) buttonStepSize;

/* Slider related. */
- (Slider *)slider;
- (id) setHandlePosition:(int)pos;
- (id) setSliderPrecision:(int)precision;
- (int) sliderPrecision;
@end

@interface HScrollbar: Scrollbar
@end

@interface VScrollbar: Scrollbar
@end

#endif
