/* -*- ObjC -*- */
#ifndef __included_gui_widgets_h
#define __included_gui_widgets_h

#include "gui.h"


/*--------------------------------------------------------------*/
/* Label.							*/
/*--------------------------------------------------------------*/

enum {
    LEFT_JUSTIFY,
    CENTRE_JUSTIFTY,
    RIGHT_JUSTIFY
} JUSTIFICATION;

@interface Label: Widget
{
    char *text;
    int text_justification;

    /* If we are getting swallowed, we might not want to draw the
       background. */
    BOOL draw_background;

    /* This is a hack to allow RaidLabel widgets to store a font,
       while still using the poseAs function. */
    void *ttf_font;
}
- (id) setDrawBackground:(BOOL)draw;
- (id) setText:(const char *)str;
- (id) setTextJustification:(int)new;
@end

/*--------------------------------------------------------------*/
/* Buttons.							*/
/*--------------------------------------------------------------*/

@interface Button: Label
{
    int (*pushed_proc)(Widget *widget, int msg, int data);
}
- (id) setPushedProc:(int (*)(Widget *, int, int))proc;
@end

@interface OkButton: Button
@end

@interface CancelButton: Button
@end

@interface ToggleButton: Button
{
    BOOL initiallyToggled;
}
@end

@interface RadioButton: Button
{
    int group;
}
- (id) setGroup:(int)group_;
@end

/*--------------------------------------------------------------*/
/* Sliders and scrollbars.					*/
/*--------------------------------------------------------------*/

#include "widget-slider.h"

/*--------------------------------------------------------------*/
/* Containers.							*/
/*--------------------------------------------------------------*/

#include "gui/widget-packingbox.h"
#include "gui/widget-pane.h"

#endif
