/* -*- ObjC -*- */
#ifndef __included_gui_raid_h
#define __included_gui_raid_h

#include "gui/gui.h"
#include "gui/gui-widgets.h"
#include "gui/widget-scrollbar.h"
#include "gui/widget-slider.h"
#include "seborrhea/seborrhea-font.h"

extern SebFont *default_raid_font;

/*------------------------------------------------------------*/
/* Labels.                                                    */
/*------------------------------------------------------------*/

@interface RaidLabel: Label
- (id) setFont:(SebFont *)fnt;
@end

/*------------------------------------------------------------*/
/* Buttons.                                                   */
/*------------------------------------------------------------*/

@interface RaidButton: Button
- (id) setFont:(SebFont *)fnt;
@end

@interface RaidCheckBox: Widget <Container>
{
    ToggleButton *button;
    Label *label;
}
- (id) setPushedProc:(int (*)(Widget *, int, int))proc;
- (id) setText:(const char *)str;
- (ToggleButton *) button;
@end

/*------------------------------------------------------------*/
/* Sliders and Scrollbars.                                    */
/*------------------------------------------------------------*/

@interface RaidHSlider: HSlider
@end

@interface RaidVSlider: VSlider
@end

@interface RaidHScrollbar: HScrollbar
@end

@interface RaidVScrollbar: VScrollbar
@end

/*------------------------------------------------------------*/
/* Containers and Combos.                                     */
/*------------------------------------------------------------*/

@interface RaidHBox: HPackingBox
{
    Sebum<SebImage> *backdrop;
}
- (id) setBackdrop:(Sebum<SebImage> *)bmp;
- (BOOL) replaceChild:(int)n With:(Widget *)new_;
@end

@interface RaidVBox: VPackingBox
{
    Sebum<SebImage> *backdrop;
}
- (id) setBackdrop:(Sebum<SebImage> *)bmp;
- (BOOL) replaceChild:(int)n With:(Widget *)new_;
@end

@interface RaidCheckSlider: Widget <Container>
{
    RaidCheckBox *button;
    RaidHSlider *slider;
}
- (id) setText:(const char *)str;
- (ToggleButton *) button;
- (RaidHSlider *) slider;
@end


void gui_raid_init(void);

#endif
