/* tank-track.m,
 *
 * Tank tracks.  Handles rotated transparency by creating new bitmaps
 * everytime we rotate.
 */

#include <allegro.h>
#include <math.h>
#ifndef NO_FBLEND
# include "fblend/include/fblend.h"
#endif
#include "common.h"
#include "debris/tank-track.h"
#include "map.h"
#include "seborrhea/seborrhea-allegro.h"
#include "seborrhea/seborrhea.h"


@implementation TankTrack
- init
{
    [super init];
    max_track_life = 1;
    return self;
}

- (id) setAngle:(double)theta
{
    int dim;

    [super setAngle:theta];

    if (not sprite)
	return self;

    if (spr)
	destroy_bitmap(spr);

    dim = M_SQRT2 * MAX([sprite width], [sprite height]);
    spr = create_bitmap(dim, dim);
    clear_to_mask_colour(spr);
    w = h = dim;

    pivot_sprite(spr, [(SebImageAllegro *)sprite bitmap], dim/2, dim/2,
	    [sprite width]/2, [sprite height]/2, rad2fix(theta));

    return self;
}

- (void) draw:(BITMAP *)dest
{
    if (spr) {
	int alpha = 0xff * health / max_track_life;

#ifndef NO_FBLEND
	fblend_trans(spr, dest, x-w/2-offsetX, y-h/2-offsetY, alpha);
#else					/* Normal Allegro routines. */
	set_trans_blender(0xff, 0xff, 0xff, alpha);
	draw_trans_sprite(dest, spr, x-w/2-offsetX, y-h/2-offsetY);
#endif					/* End: NO_FBLEND */
    }
}

- (int) update
{
    if (--health <= 0 && spr) {
        destroy_bitmap(spr);
        spr = NULL;
    }

    return [super update];
}
@end
