/* tank-debri.m,
 *
 * Debris left behind after a tank is destroyed.
 */

#include "common.h"
#include "debris/tank-debri.h"
#include "map.h"
#include "seborrhea/container-lump.h"


@implementation TankDebri
- init
{
    [super init];

    animation.anim = (SebAnimation *)[(SebLump *)[base_sebum getSebumByName:"tank-debri"] getRandomSebum];
    animation.loop = NO;
    animation.tics = animation.delay = 5;
    animation.frame = 0;
    sprite = [animation.anim getFrame:0];

    return self;
}

- (int) update
{
    if (animate(&animation))
	sprite = [animation.anim getFrame:animation.frame];

    return [super update];
}

- (void) draw:(BITMAP *)dest
{
    if (sprite) {
	int alpha = 255 * (animation.delay*animation.frame + (animation.delay-animation.tics)) / (animation.delay*[animation.anim numFrames]);

	[sprite drawTo:dest
		X:x-offsetX-[sprite width]/2
		Y:y-offsetY-[sprite height]/2 Alpha:alpha];
    }
}
@end
