/* satellite-trail.m,
 *
 * This is the trail used by both player and enemy (Boss1) satelites.
 */

#include <allegro.h>
#include "debris/satellite-trail.h"
#include "map.h"
#include "pregen-circles.h"


#define INITIAL_TRAIL_HEALTH	15


@implementation SatelliteTrail
- init
{
    [super init];
    health = INITIAL_TRAIL_HEALTH;
    return self;
}

- (void) draw:(BITMAP *)dest
{
    int alpha = 0xff * health/INITIAL_TRAIL_HEALTH;
    pregen_circlefill_add(dest, x, y-offsetY,
			  5 - (2 * health/INITIAL_TRAIL_HEALTH),
			  makecol(0xff, 0xa0, 0x00), alpha);
}

- (int) update
{
    if (--health < 0)
        return THING_DEAD;
    return [super update];
}
@end
