/* line-spark.m,
 */

#include <allegro.h>
#include <math.h>
#include "debris/line-spark.h"
#include "map.h"


@implementation LineSpark
- init
{
    [super init];
    health = 24;
    speed = 1.5;
    return self;
}

- (void) draw:(BITMAP *)dest
{
    double len = ABS(12 - health);
    double x1 = x - offsetX, x2;
    double y1 = y - offsetY, y2;

    drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
    set_add_blender(0x40, 0x40, 0x40, 10 * health);

    x2 = x1 + len*cos(angle);
    y2 = y1 - len*sin(angle);

    line(dest, x1-1, y1, x2-1, y2, makecol(0x00, 0x00, 0xff));
    line(dest, x1+1, y1, x2+1, y2, makecol(0x00, 0x00, 0xff));
    line(dest, x1,   y1, x2,   y2, makecol(0xff, 0xff, 0x00));

    drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}

- (int) update
{
    health--;
    return [super update];
}
@end
