/* ir-line.m,
 *
 * Infra-red lines used for tracking projectiles' trail.
 */

#include <allegro.h>
#include <math.h>
#include "debris/ir-line.h"
#include "map.h"


static int ir_line_life[TOTAL_DEBRI_LEVELS] = {
    1, 15, 20, 30, 40
};


@implementation IRLine
- init
{
    [super init];
    health = ir_line_life[debri_amount];
    speed = 0;
    return self;
}

- (void) draw:(BITMAP *)dest
{
    double len = 3;
    double x1 = x - offsetX, x2;
    double y1 = y - offsetY, y2;
    int c = makecol(0xff, 0x30, 0x30);

    drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
    set_add_blender(0x40, 0x40, 0x40, 0xa0 * health/ir_line_life[debri_amount]);

    x2 = x1 + len*cos(angle);
    y2 = y1 - len*sin(angle);

    line(dest, x1, y1, x2, y2, c);

    drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}

- (int) update
{
    health--;
    return [super update];
}
@end
