/* explosion.m,
 *
 * "I like it when things go kablooey, but not when it's ME!"
 */

#include <math.h>
#include "common.h"
#include "debris/explosion.h"
#include "seborrhea/container-animation.h"
#include "seborrhea/container-lump.h"
#include "sound.h"


static SebLump *small_explosions;
static SebLump *big_explosions;
static SebLump *big_explosion_sounds;


static int explosion_life[TOTAL_DEBRI_LEVELS] = {
    0, 1, 2, 5, 8
};


@implementation Explosion
+ initialize
{
    small_explosions = (SebLump *)[base_sebum getSebumByName:"explosion-small"];
    return self;
}

- init
{
    [super init];

    angle = deg2rad(rnd(-180, 180));
    speed = rnd(25, 30)/10;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)[small_explosions getRandomSebum]];
    return self;
}
@end

/*------------------------------------------------------------*/

@implementation BigExplosion
+ initialize
{
    big_explosions = (SebLump *)[base_sebum getSebumByName:"explosion-big"];
    return self;
}

- init
{
    [super init];

    life = explosion_life[debri_amount];
    angle = deg2rad(rnd(-180, 180));
    speed = rnd(20, 30) / 10;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)[big_explosions getRandomSebum]];

    return self;
}

- (int) update
{
    if (life > 0 && rnd(0, 99) < 15) {
	spawn_debris([Explosion class], x, y, HIGH_LAYER);
	life--;
    }
    return [super update];
}
@end

/*------------------------------------------------------------*/

void play_explosion_sample(int x)
{
    if (not big_explosion_sounds)
	big_explosion_sounds = (SebLump *)[base_sebum getSebumByName:"explosion-sounds"];

    //play_panned_sample((Sebum<SebSample> *)[big_explosion_sounds getRandomSebum], 192, x);
    play_panned_sample((Sebum<SebSample> *)[big_explosion_sounds getRandomSebum], x);
}
