/* chunk.m,
 *
 * Chunks are the big pieces of metal that fly off dying ships.
 */

#include <math.h>
#include "common.h"
#include "debris/chunk.h"
#include "debris/chunk.inc"
#include "seborrhea/container-lump.h"
#include "map.h"


#define CHUNK_MIN_SPEED		35
#define CHUNK_MAX_SPEED		50
#define CHUNK_OMEGA_MIN		5	/* degrees/frame. */
#define CHUNK_OMEGA_MAX		15


@implementation Chunk
- init
{
    [super init];

    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/gray"] getRandomSebum];
    angle = deg2rad(rnd(-180, 180));
    speed = rnd(CHUNK_MIN_SPEED, CHUNK_MAX_SPEED) / 10;

    omega = deg2rad(rnd(CHUNK_OMEGA_MIN, CHUNK_OMEGA_MAX)) * (rand() % 2 == 0 ? -1 : 1);

    return self;
}

- (void) draw:(BITMAP *)dest
{
    if (sprite)
	[sprite drawTo:dest X:x-offsetX Y:y-offsetY Angle:theta];
}

- (int) update
{
    theta += omega;
    simplify_angle(&theta);
    return [super update];
}
@end


@implementation ChunkBlue
- init
{
    /* "Green, Green...Oops!  I'm new to this." */
    [super init];
    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/blue"] getRandomSebum];
    return self;
}
@end

@implementation ChunkCoffee
- init
{
    [super init];
    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/coffee"] getRandomSebum];
    return self;
}
@end

@implementation ChunkGreen
- init
{
    [super init];
    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/green"] getRandomSebum];
    return self;
}
@end

@implementation ChunkRed
- init
{
    [super init];
    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/red"] getRandomSebum];
    return self;
}
@end

@implementation ChunkSardaukar
- init
{
    [super init];
    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/sardaukar"] getRandomSebum];
    return self;
}
@end
