/* -*- ObjC -*- */
#ifndef __included_debri_h
#define __included_debri_h

#include "thing.h"

#define TOTAL_DEBRI_LEVELS	5
extern int debri_amount;	/* Amount of debri to spawn. */

enum DEBRI_LAYER {
    SUBTERRANIAN_LAYER,		/* Stars. */
    FLOOR_LAYER,		/* On the floor. */
    LOW_LAYER,			/* Above ground units. */
    MEDIUM_LAYER,		/* Below air units. */
    HIGH_LAYER,			/* Above air units. */
    TOTAL_LAYERS
};

struct BITMAP;

@interface Debri: Thing
{
    double angle, speed;

    /* We want to use xv, yv to minimise using sin and cos routines. */
    double xv, yv;
    BOOL recalculate_velocity;
}
- (id) setAngle:(double)theta;
@end

@interface AnimatedDebriNoLoop: Debri
@end

void draw_debris(BITMAP *dest, enum DEBRI_LAYER layer);
void update_debris(void);
Debri *spawn_debris(Class class, int x, int y, enum DEBRI_LAYER layer);

void debris_init(void);
void debris_shutdown(void);

#endif
