/* -*- ObjC -*- */
#ifndef __included_common_h
#define __included_common_h

#include <objc/Object.h>
#include "seborrhea/container-file.h"

#define GAME_NAME		"Raid'em"
#define GAME_VERSION		"0.2"
#define GAME_NAME_AND_VERSION	GAME_NAME " " GAME_VERSION
#define GAME_SPEED		50
#define SECONDS			GAME_SPEED

/* #define screen_w	320 */
#define screen_w	352	/* Extra half a tile. */
#define screen_h	480
#define status_w	((640 - screen_w) / 2)
#define status_h	230

#ifdef __MINGW__
# define HOME_PATH_ENV		"APPDATA"
# define RAIDEM_CONFIG_PATHNAME	"raidem"
#else
# define HOME_PATH_ENV		"HOME"
# define RAIDEM_CONFIG_PATHNAME	".raidem"
#endif

#define elif		else if
#define not		!

#define FREE_BITMAP(b)		if (b) { destroy_bitmap(b); b = NULL; }
#define FREE_SEBFILE(s)		if (s) s = [s free]

#define deg2rad(theta)		((theta) * M_PI/180.0)
#define rad2deg(theta)		((theta) * 180.0/M_PI)
#define rad2fix(theta)		(-ftofix((theta) * 128.0/M_PI))

#define clear_to_mask_colour(b)		(clear_to_color(b, bitmap_mask_color(b)))
#define rect_wh(b,x,y,w,h,c)		rect(b,x,y,x+w-1,y+h-1,c)
#define rectfill_wh(b,x,y,w,h,c)	rectfill(b,x,y,x+w-1,y+h-1,c)

#define streq(a,b)		(strcmp(a,b) == 0)
#define strneq(a,b)		(strcmp(a,b) != 0)

#define SQ(alpha)			((alpha) * (alpha))

inline int rnd(int lower, int upper);
inline void simplify_angle(double *theta);

/* A global datafile which contains the base things (explosions, etc). */
extern SebFile *base_sebum;

/* Extras data for the game. */
extern int game_flags;

/* The directory raid.exe is in. */
extern char *raid_binary_directory;

/* Game state related flags. */
#define FLAG_GAME_PAUSED	0x0001	/* And confirm quit. */
#define FLAG_PLAYERS_ALIVE	0x0002
#define FLAG_QUIT		0x0004
#define FLAG_LEVEL_COMPLETE	0x0008

/* Miscellaneous flags. */
#define FLAG_REDRAW		0x0010
#define FLAG_DRAW_SHADOW	0x0020
#define FLAG_DRAW_FPS		0x0040
#define FLAG_PLAYER1_HIGH_SCORE	0x0100
#define FLAG_PLAYER2_HIGH_SCORE	0x0200
#define FLAG_REDRAW_SIDEBARS	0x0400
#define FLAG_REDRAW_STATUSBARS	0x0800
#define FLAG_HELD_SPECIAL	0x1000	/* backspace. */

#endif
