/* -*- ObjC -*- */
#ifndef __included_collision_inc
#define __included_collision_inc

/* This stuff is used for both collisions and unit lists. */
enum UNIT_LIST {
    ACTIVE_AIR_LIST		= 0x01,
    INACTIVE_AIR_LIST		= 0x02,
    ACTIVE_GROUND_LIST		= 0x04,
    INACTIVE_GROUND_LIST	= 0x08,
    ALLY_LIST			= 0x10
};

#define ACTIVE_ENEMY_LISTS	(ACTIVE_AIR_LIST|ACTIVE_GROUND_LIST)

/* Be careful not to overlap with unit list numbers! */
#define COLLIDES_WITH_PROJECTILES		0x40
#define COLLIDES_WITH_NUKES			0x80
#define COLLIDES_WITH_PROJECTILES_AND_NUKES	(COLLIDES_WITH_PROJECTILES|COLLIDES_WITH_NUKES)

enum DAMAGE_TYPE {
    DAMAGE_TYPE_PROJECTILE,
    DAMAGE_TYPE_LASER,
    DAMAGE_TYPE_TOOTHPASTE,
    DAMAGE_TYPE_VULCAN,
    DAMAGE_TYPE_POWERUP,
    DAMAGE_TYPE_NUKE,
    DAMAGE_TYPE_UNIT
};

#endif
