/* unit-anim.m,
 *
 * Basic, easy to use animation structure.  Supports looping.
 */

#include "animation.h"


BOOL animate(animation_t *anim)
{
    if (!anim->anim)
	return NO;

    if (--(anim->tics) <= 0) {
	unsigned int f = [anim->anim nextFrame:anim->frame];

    	/* Returns yes if we changed frames. */
	if ((f > anim->frame) || (anim->loop)) {
	    anim->frame = f;
	    anim->tics = anim->delay;
	    return YES;
	}

	/* This frame has served its time and is ready to change. */
	anim->tics = 0;
    }
    return NO;
}
