/* This file is part of the alrand library.
   alrand is Copyright by Vincent Penquerc'h <lyrian -at- kezako -dot- net>.

   The alrand library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The alrand library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the alrand Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA. */

#include <stdio.h>

#define SIZE (48UL*1024UL*1024UL) /* 48 million */

int main()
{
  unsigned long n;
  static unsigned char array[SIZE/8]; /* 8 bits per byte */
  memset(array,0,sizeof(array));
  for (n=2;n<SIZE;n++) {
    unsigned long walker=n+n;
    /*printf("Testing %d....\n",n);*/
    if (!(array[n/8]&(1<<(n%8)))) printf("prime: %lu\n",n);
    while (walker<SIZE) {
      array[walker/8]|=(1<<(walker%8));
      walker+=n;
    }
  }
}
