/* This file is part of the alrand library.
   alrand is Copyright by Vincent Penquerc'h <lyrian -at- kezako -dot- net>.

   The alrand library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The alrand library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the alrand Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA. */

#ifndef _ALRAND_LOAD_SAVE_STDIO_H_
#define _ALRAND_LOAD_SAVE_STDIO_H_

#include "alrand.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Platform dependent - do not load and save on different architectures */

static inline void alrandint_write_to_fd(alrand_uint32_t data,void *fd)
{
  write((int)fd,&data,sizeof(data));
}

static inline alrand_uint32_t alrandint_read_from_fd(void *fd)
{
  alrand_uint32_t data;
  read((int)fd,&data,sizeof(data));
  return data;
}

int alrand_save_to_fd(alrand_state *state,int fd)
{
  return alrand_save(state,&alrandint_write_to_fd,(void*)fd);
}

alrand_state *alrand_load_from_fd(int fd)
{
  return alrand_load(&alrandint_read_from_fd,(void*)fd);
}

#ifdef __cplusplus
}
#endif

#endif
