/* This file is part of the alrand library.
   alrand is Copyright by Vincent Penquerc'h <lyrian -at- kezako -dot- net>.

   The alrand library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The alrand library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the alrand Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA. */

#ifndef _ALRAND_LOAD_SAVE_ALLEGRO_PACKFILE_H_
#define _ALRAND_LOAD_SAVE_ALLEGRO_PACKFILE_H_

#include "alrand.h"

#ifdef __cplusplus
extern "C" {
#endif

struct PACKFILE;
typedef struct PACKFILE PACKFILE;

/* Will only work if long is 32 bit long */

static inline void alrandint_write_to_allegro_packfile(alrand_uint32_t data,void *f)
{
  pack_iputl(*(long*)&data,(PACKFILE*)f);
}

static inline alrand_uint32_t alrandint_read_from_allegro_packfile(void *f)
{
  long data=pack_igetl((PACKFILE*)f);
  return *(alrand_uint32_t*)&data;
}

int alrand_save_to_allegro_packfile(alrand_state *state,PACKFILE *f)
{
  return alrand_save(state,&alrandint_write_to_allegro_packfile,(void*)f);
}

alrand_state *alrand_load_from_allegro_packfile(PACKFILE *f)
{
  return alrand_load(&alrandint_read_from_allegro_packfile,(void*)f);
}

#ifdef __cplusplus
}
#endif

#endif
