#define ALLEGRO_INCLUDE_MATH_H

#include <allegro.h>
#include <math.h>

// General Defines
#define APP_NAME		"Joystick test"
#define WINDOW_X		640
#define WINDOW_Y		480
#define HALF_X			(WINDOW_X>>1)
#define HALF_Y			(WINDOW_Y>>1)
#define DRAW_MODE_DOUBLE_BUFFER		1
#define DRAW_MODE_PAGE_FLIP			2
#define DRAW_MODE_DIRTY_RECTS		3
#define	PI				(3.1415926535898)
#define	PII				(31415)
#define	PII2			(6283)
#include "colors.h"

FFEFFECT* ExplodeFFEffect;
FFEFFECT* ConstantFFEffect;
FFEFFECT* FireFFEffect;

int ff_joystick_n=-1;

void draw_screen(BITMAP *buffer) {
	acquire_bitmap(buffer);
	clear_bitmap(buffer);
	
	int y=-10;
	
	textprintf(buffer,font,2,y+=10,color[WHITE],"Joysticks:%i",num_joysticks);
	for (int j=0; j<num_joysticks; j++) {
		textprintf(buffer,font,8,y+=10,color[WHITE],"Joy %i (Force feedback? %s)",j+1,ff_joystick_has(j)?"yes":"no");
		textprintf(buffer,font,12,y+=10,color[WHITE],"Sticks: %i Buttons: %i",joy[j].num_sticks,joy[j].num_buttons);
		for (int c=0; c<joy[j].num_sticks; c++) {
			textprintf(buffer,font,15,y+=10,color[WHITE],"%s: (%iaxis)",joy[j].stick[c].name,joy[j].stick[c].num_axis);
			for (int a=0; a<joy[j].stick[c].num_axis; a++)
				textprintf(buffer,font,20,y+=10,color[BLUE],"%s: pos:%i d1:%i d2:%i",joy[j].stick[c].axis[a].name,joy[j].stick[c].axis[a].pos,joy[j].stick[c].axis[a].d1,joy[j].stick[c].axis[a].d2);
		}
		for (int b=0; b<joy[j].num_buttons; b++)
			if (joy[j].button[b].b) textprintf(buffer, font, 25, y+=10, color[RED], "%s pressed", joy[j].button[b].name);
	}

	release_bitmap(buffer);
}

void update_game_logic() {
	poll_keyboard();
	poll_mouse();
	poll_joystick();	// REQUIRED
	if (ff_joystick_n>=0) {
		if (joy[ff_joystick_n].button[0].b) ff_play_effect( ExplodeFFEffect );
		if (joy[ff_joystick_n].button[1].b) ff_play_effect( ConstantFFEffect );
		if (joy[ff_joystick_n].button[2].b) ff_play_effect( FireFFEffect );
	}
}

int pleasequit=false;
void closeproc() {
	pleasequit=true;
} END_OF_FUNCTION(closeproc);

int current_color_depth=0;
BITMAP *db;
BITMAP *page[2];
int page_num = 1;
int drawmode = DRAW_MODE_PAGE_FLIP;

void updatescreen() {
	
	if (drawmode==DRAW_MODE_PAGE_FLIP) {
		// page flip
		show_video_bitmap(page[page_num]);
		page_num = 1-page_num;
		db = page[page_num];
	} else {
		acquire_screen();
		blit(db, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
		release_screen();
	}
}

int main () {
	allegro_init();
	set_window_title(APP_NAME);
	set_window_close_hook(&closeproc);


	int depths[] = {32,24,16,15,8};
	for (int depth = 0;depth<7;) {
		set_color_depth(current_color_depth=(depth==6?desktop_color_depth(),depth++:depths[depth++]));
		if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, WINDOW_X, WINDOW_Y, 0, 0)==0) goto done;
	}
	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
	allegro_message("Unable to set a suitable graphic mode\n%s\n", allegro_error);
	return 1;	// didn't find a res

	done:		// found a res
	set_display_switch_mode(SWITCH_BACKGROUND);

	// create two video memory bitmaps for page flipping
	page[0] = create_video_bitmap(SCREEN_W, SCREEN_H);
	page[1] = create_video_bitmap(SCREEN_W, SCREEN_H);
	db = page[0];

	if ((!page[0]) || (!page[1])) {
		// Double-buffering
		drawmode=DRAW_MODE_DOUBLE_BUFFER;
		db = create_bitmap(WINDOW_X, WINDOW_Y);
	}


	clear_bitmap(screen);

	text_mode(-1);

	init_color_table();

	install_keyboard();


   if (install_joystick(JOY_TYPE_AUTODETECT) != 0) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Error initialising joystick\n%s\n", allegro_error);
      return 1;
   }
	for (int i=0; i<num_joysticks; i++)
		if (ff_joystick_has(i)) ff_joystick_n=i;

	if (ff_joystick_n>=0) {
		ExplodeFFEffect = ff_create_effect();
		ConstantFFEffect = ff_create_effect();
		FireFFEffect = ff_create_effect();
		ff_make_periodic_effect(ff_joystick_n,ExplodeFFEffect);
		ff_make_constant_force_effect(ff_joystick_n,ConstantFFEffect,0);
		ff_make_fire_force_effect(ff_joystick_n,FireFFEffect);
	}
   
	while (!pleasequit) {
		if (key[KEY_ESC]) break;
		update_game_logic();
		draw_screen(db);
		updatescreen();
	}
	if (ff_joystick_n>=0) {
		if (ExplodeFFEffect) ff_destroy_effect( ExplodeFFEffect );
		if (ConstantFFEffect) ff_destroy_effect( ConstantFFEffect );
		if (FireFFEffect) ff_destroy_effect( FireFFEffect );
	}
	
	
	return 0;
}
END_OF_MAIN();
