////////////////////////////////////////////////////////////////////////////////
// Deity - By Carl Olsson 2000
// world.h World class
////////////////////////////////////////////////////////////////////////////////

#ifndef _WORLD_H // Check if file allready included
#define _WORLD_H

#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "object.h"
#include "sprite.h"

// Types ///////////////////////////////////////////////////////////////////////
typedef struct TERRAIN_MAP {
   int a;
   int b;
   int c;
   int d;
   int sprite;
} TERRAIN_MAP;

class Terrain {
public:
   Terrain(void) {}
   ~Terrain(void) {}
   void open(char *const fileName);
   void close(void);
   void draw(BITMAP *const destination, int x, int y, int a, int b, int c, int d);
private:
   TERRAIN_MAP *terrainMap;
   SpriteSet spriteSet;
};

// Square Type
class Square {
public:
   Square(void) {}
   ~Square(void) {}
   char getKind(void) { return kind; }
   void setKind(char _kind) { kind = _kind; }
private:
   unsigned short kind;
   Terrain *terrain;
};

// Point Type
class Point {
public:
   int getZ(void) { return z; }
   void setZ(int _z) { z = _z; }
private:
   signed short z;
};

// World Type
class World {
public:
   World(void);
   World(int _w, int _h);
   ~World(void);
   char *getName(void) { return name; }
   void setName(char *const _name) { strcpy(name, _name); }
   void populate(int activeCount, int staticCount);
   void depopulate(void);
   int getW(void) { return w; }
   int getH(void) { return h; }
   void setW(int _w) { w = _w; }
   void setH(int _h) { h = _h; }
   double getZ(double _x, double _y);
   Point *getPoint(int _x, int _y);
   int getPointZ(int _x, int _y);
   void generatePointMap(int roughness, int magnitude);
   void raiseDiamond(int _x, int _y, int amount);
   void raisePointDiamond(int _x, int _y, int value);
   void lowerDiamond(int _x, int _y, int amount);
   void lowerPointDiamond(int _x, int _y, int value);
   void raiseSquare(int _x, int _y, int amount);
   void raisePointSquare(int _x, int _y, int value);
   void lowerSquare(int _x, int _y, int amount);
   void lowerPointSquare(int _x, int _y, int value);
   void generateSquareMap(void);
   Square *getSquare(int _x, int _y);
   void update(void);
   void updateSquare(int x, int y);
   void *createSquares(void);
   void *destroySquares(void);
   void *createPoints(void);
   void *destroyPoints(void);
   int getWaterLevel(void) { return waterLevel; }
   void setWaterLevel(int _waterLevel) { waterLevel = _waterLevel; }
   ObjectList objects;
private:
   char        name[32 + 1];
   Square      *squares;
   Point       *points;
   unsigned short w;
   unsigned short h;
   short int waterLevel;
};

extern World *objectWorld;

#endif // _WORLD_H
