////////////////////////////////////////////////////////////////////////////////
// Deity - By Carl Olsson 2003
// view.cpp View class
////////////////////////////////////////////////////////////////////////////////

#include "view.h"
#include "main.h"
#include <math.h>
#include "interface.h"

int spritesDrawn;
int objectsDrawn;
int squaresDrawn;

typedef struct TERRAIN_TILESET {
   int terrain;
   char *spriteSet;
} TERRAIN_TILESET;

TERRAIN_TILESET terrainSpriteSets[] = {
 { 0, "Grass" },
 { 1, "Dirt" },
 { 2, "Sand" },
 { -1, NULL }
};

TERRAIN_MAP terr[19] = {
 {  0,  0,  0, -1,  0 },
 {  0,  1,  0, -1,  1 },
 {  0,  1,  1,  1,  2 },
 {  0,  1,  2,  1,  3 },
 {  0, -1,  0,  0,  4 },
 {  0,  0, -1,  0,  5 },
 {  0,  0,  0,  0,  6 },
 {  0,  0,  1,  0,  7 },
 {  0,  1,  0,  0,  8 },
 {  0,  1,  1,  0,  9 },
 {  0, -1, -2, -1, 10 },
 {  0, -1, -1, -1, 11 },
 {  0, -1,  0, -1, 12 },
 {  0,  0, -1, -1, 13 },
 {  0, -1,  0,  1, 14 },
 {  0,  0,  0,  1, 15 },
 {  0,  0,  1,  1, 16 },
 {  0,  1,  0,  1, 17 },
 {  0, -1, -1,  0, 18 }
};

TERRAIN_MAP wat[19] = {
 {  0,  0,  0, -1,  4 },
 {  0,  1,  0, -1,  2 },
 {  0,  1,  1,  1,  4 },
 {  0,  1,  2,  1,  3 },
 {  0, -1,  0,  0,  4 },
 {  0,  0, -1,  0,  4 },
 {  0,  0,  0,  0,  4 },
 {  0,  0,  1,  0,  3 },
 {  0,  1,  0,  0,  2 },
 {  0,  1,  1,  0,  1 },
 {  0, -1, -2, -1,  1 },
 {  0, -1, -1, -1,  1 },
 {  0, -1,  0, -1,  4 },
 {  0,  0, -1, -1,  4 },
 {  0, -1,  0,  1,  0 },
 {  0,  0,  0,  1,  0 },
 {  0,  0,  1,  1,  4 },
 {  0,  1,  0,  1,  4 },
 {  0, -1, -1,  0,  4 }
};

void bilinterp(const double posX, const double posY, const double x1, const double y1, const double x2, const double y2, const double x3, const double y3, const double x4, const double y4, double *const outX, double *const outY)
{
   double topX = x1 + (x2 - x1) * posX;
   double bottomX = x3 + (x4 - x3) * posX;
   *outX = topX + (bottomX - topX) * posY;

   double topY = y1 + (y2 - y1) * posX;
   double bottomY = y4 + (y4 - y3) * posX;
   *outY = topY + (bottomY - topY) * posY;
}

void pixelInSquarePosition(const int pixelX, const int pixelY, const int x1, const int y1, const int x2, const int y2, const int x3, const int y3, const int x4, const int y4, double *const squareX, double *const squareY)
{
}

float lineSide(const float x, const float y, const float x1, const float y1, const float x2, const float y2)
{
   float line_x, line_y;
   float point_x, point_y;

   line_x = x2 - x1;
   line_y = y2 - y1;

   point_x = x - x1;
   point_y = y - y1;

   return point_x * line_y - point_y * line_x;
}

World *View::getWorld(void)
{
   return getInterface()->getWorld();
}
   
void View::viewToScreen(const double viewX, const double viewY, double *const screenX, double *const screenY)
{
   *screenX = viewX + getX();
   *screenY = viewY + getY();
}

void View::screenToView(const double screenX, const double screenY, double *const viewX, double *const viewY)
{
   *viewX = screenX - getX();
   *viewY = screenY - getY();
}

void View::screenToGame(const double screenX, const double screenY, double *const gameX, double *const gameY)
{
   double viewX, viewY;
   screenToView(screenX, screenY, &viewX, &viewY);
   viewToGame(viewX, viewY, gameX, gameY);
}

void View::screenToGame(const double screenX, const double screenY, double *const gameX, double *const gameY, double *const gameZ)
{
   double viewX, viewY;
   screenToView(screenX, screenY, &viewX, &viewY);
   viewToGame(viewX, viewY, gameX, gameY, gameZ);
}

void View::gameToScreen(const double gameX, const double gameY, const double gameZ, double *screenX, double *screenY)
{
   double viewX, viewY;
   gameToView(gameX, gameY, gameZ, &viewX, &viewY);
   viewToScreen(viewX, viewY, screenX, screenY);
}

void View::gameToView(const double gameX, const double gameY, const double gameZ, double *viewX, double *viewY)
{
   *viewX = (gameX - focusX) * gameXPixelX + (gameY - focusY) * gameYPixelX + (gameZ - focusZ) * gameZPixelX + getOffsetX();
   *viewY = (gameX - focusX) * gameXPixelY + (gameY - focusY) * gameYPixelY + (gameZ - focusZ) * gameZPixelY + getOffsetY();
}

void View::viewToGame(const double viewX, const double viewY, double *gameX, double *gameY, double *gameZ)
{
   double sx, sy;
   double x, y;
   int start_x, start_y, end_x, end_y;
   int c;
   int out_x, out_y, in_x, in_y;
   int step;
   bool found = false;

   sx = (((viewX - getOffsetX()) / (double)gameYPixelX * (double)gameYPixelY / (double)gameXPixelY) - ((viewY - getOffsetY()) / (double)gameXPixelY)) / (((double)gameXPixelX / (double)gameYPixelX * (double)gameYPixelY / (double)gameXPixelY) - (double)1) + getFocusX();
   sy = (((viewY - getOffsetY()) / (double)gameXPixelY * (double)gameXPixelX / (double)gameYPixelX) - ((viewX - getOffsetX()) / (double)gameYPixelX)) / (((double)gameYPixelY / (double)gameXPixelY * (double)gameXPixelX / (double)gameYPixelX) - (double)1) + getFocusY();

   *gameX = sx;
   *gameY = sy;
   *gameZ = 0;

   if (*gameX < 0) *gameX = 0;
   if (*gameX >= getWorld()->getW()) *gameX = getWorld()->getW() - 1;
   if (*gameY < 0) *gameY = 0;
   if (*gameY >= getWorld()->getH()) *gameY = getWorld()->getH() - 1;

   c = (int)(sy - sx);
   if (sx - 0 > sy - 0) {
      start_y = 0;
      start_x = start_y - c;
   }
   else {
      start_x = 0;
      start_y = start_x + c;
   }
   if (getWorld()->getW() - sx > getWorld()->getH() - sy) {
      end_y = getWorld()->getH() - 1;
      end_x = end_y - c;
   }
   else {
      end_x = getWorld()->getW() - 1;
      end_y = end_x + c;
   }

   if (lineSide(sx, sy, start_x, start_y, end_x, end_y)) {
      out_x = 1;
      out_y = 0;
      in_x = 0;
      in_y = 1;
   }
   else {
      out_x = 0;
      out_y = 1;
      in_x = 1;
      in_y = 0;
   }

   if (sx > sy) {
      step = 0;
   }
   else {
      step = 1;
   }

   x = start_x;
   y = start_y;
   while(!found && x <= end_x && y <= end_y) {
      if (pixelInSquare((int)viewX, (int)viewY, (int)x, (int)y)) {
         *gameX = x;
         *gameY = y;
         *gameZ = getWorld()->getZ(*gameX, *gameY);
         found = true;
      }
      if (step == 0) {
         x += out_x;
         y += out_y;
         step = 1;
      }
      else {
         x += in_x;
         y += in_y;
         step = 0;
      }
   }
}

void View::viewToGame(const double viewX, const double viewY, double *gameX, double *gameY)
{
   *gameX = (((viewX - getOffsetX()) / (double)gameYPixelX * (double)gameYPixelY / (double)gameXPixelY) - ((viewY - getOffsetY()) / (double)gameXPixelY)) / (((double)gameXPixelX / (double)gameYPixelX * (double)gameYPixelY / (double)gameXPixelY) - (double)1) + getFocusX();
   *gameY = (((viewY - getOffsetY()) / (double)gameXPixelY * (double)gameXPixelX / (double)gameYPixelX) - ((viewX - getOffsetX()) / (double)gameYPixelX)) / (((double)gameYPixelY / (double)gameXPixelY * (double)gameXPixelX / (double)gameYPixelX) - (double)1) + getFocusY();
}

void View::coordsToPixel(const double coordsX, const double coordsY, const double coordsZ, int *const pixelX, int *const pixelY)
{
   double vx, vy;
   double px, py;
   gameToView(coordsX, coordsY, coordsZ, &vx, &vy);
   viewToScreen(vx, vy, &px, &py);
   *pixelX = (int)(px);
   *pixelY = (int)(py);
}

void View::squareToPixel(const double squareX, const double squareY, int *const pixelX, int *const pixelY)
{
   coordsToPixel(squareX, squareY, getWorld()->getZ(squareX, squareY), pixelX, pixelY);
}

void View::pixelToSquare(const double pixelX, const double pixelY, double *const squareX, double *const squareY)
{
   double vx, vy;
   double gx, gy;
   screenToView(pixelX, pixelY, &vx, &vy);
   viewToGame(vx, vy, &gx, &gy);
   *squareX = gx;
   *squareY = gy;
}

bool View::pixelInSquare(const int pixelX, const int pixelY, const int squareX, const int squareY)
{
   int x1, y1, x2, y2, x3, y3, x4, y4;

   squareToPixel(squareX + 0, squareY + 0, &x1, &y1);
   squareToPixel(squareX + 1, squareY + 0, &x2, &y2);
   squareToPixel(squareX + 1, squareY + 1, &x3, &y3);
   squareToPixel(squareX + 0, squareY + 1, &x4, &y4);

   return lineSide(pixelX, pixelY, x1, y1, x2, y2) <= 0 &&
          lineSide(pixelX, pixelY, x2, y2, x3, y3) <= 0 &&
          lineSide(pixelX, pixelY, x3, y3, x4, y4) <= 0 &&
          lineSide(pixelX, pixelY, x4, y4, x1, y1) <= 0;
}

bool View::pixelInPoint(const int pixelX, const int pixelY, const int _x, const int _y)
{
#define LIMIT(value, lower, upper) ((value < lower) ? lower : ((value > upper) ? upper : value))
   int x1, y1, x2, y2, x3, y3, x4, y4, x5, y5, x6, y6, x7, y7, x8, y8, x9, y9;

   coordsToPixel(_x + 0.0, _y - 0.5, getWorld()->getZ(LIMIT(_x + 0.0, 0, getWorld()->getW()), LIMIT(_y - 0.5, 0, getWorld()->getH())), &x1, &y1);
   coordsToPixel(_x + 0.5, _y - 0.5, getWorld()->getZ(LIMIT(_x + 0.5, 0, getWorld()->getW()), LIMIT(_y - 0.5, 0, getWorld()->getH())), &x2, &y2);
   coordsToPixel(_x + 0.5, _y + 0.0, getWorld()->getZ(LIMIT(_x + 0.5, 0, getWorld()->getW()), LIMIT(_y + 0.0, 0, getWorld()->getH())), &x3, &y3);
   coordsToPixel(_x + 0.5, _y + 0.5, getWorld()->getZ(LIMIT(_x + 0.5, 0, getWorld()->getW()), LIMIT(_y + 0.5, 0, getWorld()->getH())), &x4, &y4);
   coordsToPixel(_x + 0.0, _y + 0.5, getWorld()->getZ(LIMIT(_x + 0.0, 0, getWorld()->getW()), LIMIT(_y + 0.5, 0, getWorld()->getH())), &x5, &y5);
   coordsToPixel(_x - 0.5, _y + 0.5, getWorld()->getZ(LIMIT(_x - 0.5, 0, getWorld()->getW()), LIMIT(_y + 0.5, 0, getWorld()->getH())), &x6, &y6);
   coordsToPixel(_x - 0.5, _y + 0.0, getWorld()->getZ(LIMIT(_x - 0.5, 0, getWorld()->getW()), LIMIT(_y + 0.0, 0, getWorld()->getH())), &x7, &y7);
   coordsToPixel(_x - 0.5, _y - 0.5, getWorld()->getZ(LIMIT(_x - 0.5, 0, getWorld()->getW()), LIMIT(_y - 0.5, 0, getWorld()->getH())), &x8, &y8);

   coordsToPixel(_x + 0.0, _y + 0.0, getWorld()->getZ(LIMIT(_x + 0.0, 0, getWorld()->getW()), LIMIT(_y + 0.0, 0, getWorld()->getH())), &x9, &y9);

   return (lineSide(pixelX, pixelY, x1, y1, x2, y2) <= 0 &&
           lineSide(pixelX, pixelY, x2, y2, x3, y3) <= 0 &&
           lineSide(pixelX, pixelY, x3, y3, x9, y9) <= 0 &&
           lineSide(pixelX, pixelY, x9, y9, x1, y1) <= 0) ||
          (lineSide(pixelX, pixelY, x3, y3, x4, y4) <= 0 &&
           lineSide(pixelX, pixelY, x4, y4, x5, y5) <= 0 &&
           lineSide(pixelX, pixelY, x5, y5, x9, y9) <= 0 &&
           lineSide(pixelX, pixelY, x9, y9, x3, y3) <= 0) ||
          (lineSide(pixelX, pixelY, x5, y5, x6, y6) <= 0 &&
           lineSide(pixelX, pixelY, x6, y6, x7, y7) <= 0 &&
           lineSide(pixelX, pixelY, x7, y7, x9, y9) <= 0 &&
           lineSide(pixelX, pixelY, x9, y9, x5, y5) <= 0) ||
          (lineSide(pixelX, pixelY, x5, y5, x6, y6) <= 0 &&
           lineSide(pixelX, pixelY, x6, y6, x7, y7) <= 0 &&
           lineSide(pixelX, pixelY, x7, y7, x9, y9) <= 0 &&
           lineSide(pixelX, pixelY, x9, y9, x1, y1) <= 0);
}

void View::pixelToSquareWithZ(const double pixelX, const double pixelY, double *const squareX, double *const squareY)
{
   double vx, vy;
   double gx, gy, gz;
   screenToView(pixelX, pixelY, &vx, &vy);
   viewToGame(vx, vy, &gx, &gy, &gz);
   *squareX = gx;
   *squareY = gy;
//   *squareZ = gz;
}

void View::pixelToPointWithZ(const double pixelX, const double pixelY, double *const squareX, double *const squareY)
{
   double vx, vy;
   double gx, gy, gz;
   screenToView(pixelX, pixelY, &vx, &vy);
   viewToGame(vx, vy, &gx, &gy, &gz);
   *squareX = gx;
   *squareY = gy;
//   *squareZ = gz;
}

////////////////////////////////////////////////////////////////////////////////
// View Draw
// Draws the view to destination
////////////////////////////////////////////////////////////////////////////////
void View::draw(BITMAP *const destination)
{
   rectfill(destination, getX(), getY(), getX() + getW() - 1, getY() + getH() - 1, 0);
   set_clip(destination, getX(), getY(), getX() + getW() - 1, getY() + getH() - 1);
   drawWorld(destination);
   drawOverlay(destination);
}

////////////////////////////////////////////////////////////////////////////////
// View Draw Square Highlight
// Draws a square highlight to the view image
////////////////////////////////////////////////////////////////////////////////
void View::drawSquareHighlight(BITMAP *const destination, const int _x, const int _y)
{
   if ((_x >= 0) && (_x < getWorld()->getW()) &&
       (_y >= 0) && (_y < getWorld()->getH())) {
      int ax, ay, bx, by, cx, cy, dx, dy;
      squareToPixel(_x + 0, _y + 0, &ax, &ay);
      squareToPixel(_x + 1, _y + 0, &bx, &by);
      squareToPixel(_x + 1, _y + 1, &cx, &cy);
      squareToPixel(_x + 0, _y + 1, &dx, &dy);

      line(destination, ax + 0, ay + 0, bx - 2, by - 1, cursorColour);
      line(destination, cx + 0, cy - 1, bx - 2, by + 0, cursorColour);
      line(destination, cx - 1, cy - 1, dx + 1, dy + 0, cursorColour);
      line(destination, ax - 1, ay + 0, dx + 1, dy - 1, cursorColour);
   }
}

#define LIMIT(value, lower, upper) ((value < lower) ? lower : ((value > upper) ? upper : value))
void View::drawPointCursor(BITMAP *destination, const int _x, const int _y)
{
   int x1, y1, x2, y2, x3, y3, x4, y4, x5, y5, x6, y6, x7, y7, x8, y8, x9, y9;
   
   coordsToPixel(_x + 0.0, _y - 0.5, getWorld()->getZ(LIMIT(_x + 0.0, 0, getWorld()->getW()), LIMIT(_y - 0.5, 0, getWorld()->getH())), &x1, &y1);
   coordsToPixel(_x + 0.5, _y - 0.5, getWorld()->getZ(LIMIT(_x + 0.5, 0, getWorld()->getW()), LIMIT(_y - 0.5, 0, getWorld()->getH())), &x2, &y2);
   coordsToPixel(_x + 0.5, _y + 0.0, getWorld()->getZ(LIMIT(_x + 0.5, 0, getWorld()->getW()), LIMIT(_y + 0.0, 0, getWorld()->getH())), &x3, &y3);
   coordsToPixel(_x + 0.5, _y + 0.5, getWorld()->getZ(LIMIT(_x + 0.5, 0, getWorld()->getW()), LIMIT(_y + 0.5, 0, getWorld()->getH())), &x4, &y4);
   coordsToPixel(_x + 0.0, _y + 0.5, getWorld()->getZ(LIMIT(_x + 0.0, 0, getWorld()->getW()), LIMIT(_y + 0.5, 0, getWorld()->getH())), &x5, &y5);
   coordsToPixel(_x - 0.5, _y + 0.5, getWorld()->getZ(LIMIT(_x - 0.5, 0, getWorld()->getW()), LIMIT(_y + 0.5, 0, getWorld()->getH())), &x6, &y6);
   coordsToPixel(_x - 0.5, _y + 0.0, getWorld()->getZ(LIMIT(_x - 0.5, 0, getWorld()->getW()), LIMIT(_y + 0.0, 0, getWorld()->getH())), &x7, &y7);
   coordsToPixel(_x - 0.5, _y - 0.5, getWorld()->getZ(LIMIT(_x - 0.5, 0, getWorld()->getW()), LIMIT(_y - 0.5, 0, getWorld()->getH())), &x8, &y8);

   coordsToPixel(_x + 0.0, _y + 0.0, getWorld()->getZ(LIMIT(_x + 0.0, 0, getWorld()->getW()), LIMIT(_y + 0.0, 0, getWorld()->getH())), &x9, &y9);

   line(destination, x1, y1, x2, y2, cursorColour);
   line(destination, x2, y2, x3, y3, cursorColour);
   line(destination, x3, y3, x4, y4, cursorColour);
   line(destination, x4, y4, x5, y5, cursorColour);
   line(destination, x5, y5, x6, y6, cursorColour);
   line(destination, x6, y6, x7, y7, cursorColour);
   line(destination, x7, y7, x8, y8, cursorColour);
   line(destination, x8, y8, x1, y1, cursorColour);

   circlefill(destination, x9, y9, 2, cursorColour);
//   spriteSetRegister->find("Cursors")->getSprite(1)->draw(destination, x9, y9);
}

////////////////////////////////////////////////////////////////////////////////
// View Draw Square Cursor
// Draws a square cursor
////////////////////////////////////////////////////////////////////////////////
void View::drawSquareCursor(BITMAP *destination, const int _x, const int _y)
{
   int x1, y1, x2, y2, x3, y3, x4, y4;
   
   coordsToPixel(_x + 0, _y + 0, getWorld()->getPointZ(LIMIT(_x + 0, 0, getWorld()->getW() - 1), LIMIT(_y + 0, 0, getWorld()->getH() - 1)), &x1, &y1);
   coordsToPixel(_x + 1, _y + 0, getWorld()->getPointZ(LIMIT(_x + 1, 0, getWorld()->getW() - 1), LIMIT(_y + 0, 0, getWorld()->getH() - 1)), &x2, &y2);
   coordsToPixel(_x + 1, _y + 1, getWorld()->getPointZ(LIMIT(_x + 1, 0, getWorld()->getW() - 1), LIMIT(_y + 1, 0, getWorld()->getH() - 1)), &x3, &y3);
   coordsToPixel(_x + 0, _y + 1, getWorld()->getPointZ(LIMIT(_x + 0, 0, getWorld()->getW() - 1), LIMIT(_y + 1, 0, getWorld()->getH() - 1)), &x4, &y4);

   line(destination, x1, y1, x2, y2, cursorColour);
   line(destination, x2, y2, x3, y3, cursorColour);
   line(destination, x3, y3, x4, y4, cursorColour);
   line(destination, x4, y4, x1, y1, cursorColour);
}
   
////////////////////////////////////////////////////////////////////////////////
// View Draw Overlay
// Draws the view overlay
////////////////////////////////////////////////////////////////////////////////
void View::drawOverlay(BITMAP *const destination)
{
   switch (cursorMode) {
   case 0:
      drawPointCursor(destination, cursorX, cursorY);
      break;
   case 1:
      drawSquareCursor(destination, cursorX, cursorY);
      break;
   }
}

////////////////////////////////////////////////////////////////////////////////
// View Draw Square
// Draws a square to the view image
////////////////////////////////////////////////////////////////////////////////
void View::drawSquare(BITMAP *const destination, const int _x, const int _y)
{
   Square *square = NULL;
   int terrainX, terrainY;
   int waterX, waterY;
   signed int a, b, c, d;
   signed int aa, bb, cc, dd;
   int sprite;
   int waterSprite;
   int waterPoints;
   int i;

   square = getWorld()->getSquare(_x, _y);

   if (square == NULL) return;

   squaresDrawn++;

   a = getWorld()->getPoint(_x + 0, _y + 0)->getZ();
   b = getWorld()->getPoint(_x + 1, _y + 0)->getZ();
   c = getWorld()->getPoint(_x + 1, _y + 1)->getZ();
   d = getWorld()->getPoint(_x + 0, _y + 1)->getZ();

   aa = a - a;
   bb = b - a;
   cc = c - a;
   dd = d - a;

//   char packed_sprite = ((aa & 0x4) >> 0) + ((bb & 0x4) >> 2) + ((cc & 0x4) >> 4) + ((dd & 0x4) >> 6);

   sprite = -1;
   for (i = 0; i < 19; i++) {
      if ((terr[i].a == aa) &&
          (terr[i].b == bb) &&
          (terr[i].c == cc) &&
          (terr[i].d == dd)) {
         sprite = terr[i].sprite;
      }
   }
   if (sprite < 0) {
      allegro_exit();
      printf("Terrain\n");
      printf("aa = %d, bb = %d, cc = %d, dd = %d\n", aa, bb, cc, dd);
      printf("a = %d, b = %d, c = %d, d = %d\n", a, b, c, d);
      printf("_x = %d, _y = %d\n", _x, _y);
      exit(EXIT_FAILURE);
   }

   // Calculate screen location of terrain sprite
   squareToPixel(_x, _y, &terrainX, &terrainY);

   SpriteSet *spriteSet = NULL;
   for (i = 0; terrainSpriteSets[i].terrain >= 0; i++) {
      if (square->getKind() == terrainSpriteSets[i].terrain) {
         spriteSet = spriteSetRegister->find(terrainSpriteSets[i].spriteSet);
      }
   }
   if (spriteSet == NULL) exit(69);

   int terrainUp = spriteSet->getSprite(sprite)->getY();
   int terrainDown = spriteSet->getSprite(sprite)->getH() - spriteSet->getSprite(sprite)->getY();
   int terrainLeft = spriteSet->getSprite(sprite)->getX();
   int terrainRight = spriteSet->getSprite(sprite)->getW() - spriteSet->getSprite(sprite)->getX();
   if (terrainX + terrainRight >= 0 &&
       terrainY + terrainDown >= 0 &&
       terrainX - terrainLeft < getW() &&
       terrainY - terrainUp < getH()) {
      // Draw terrain
      int squareDepth = (a + b + c + d) / 4;
      int lightLevel = 255 + ((squareDepth - getWorld()->getWaterLevel()) * 16);
      if (lightLevel > 255 || lightLevel < 0) {
         lightLevel = 0;
      }
      if (squareDepth < getWorld()->getWaterLevel()) {
         spriteSet->getSprite(sprite)->drawLit(destination, terrainX, terrainY, lightLevel, &lightMap);
      }
      else {
//         spriteSet->getSprite(sprite)->drawTrans(destination, terrainX, terrainY, &transMap);
         spriteSet->getSprite(sprite)->draw(destination, terrainX, terrainY);
      }
      spritesDrawn++;
   }

   // Draw water
   SpriteSet *water[4];
   water[0] = spriteSetRegister->find("Water0");
   water[1] = spriteSetRegister->find("Water1");
   water[2] = spriteSetRegister->find("Water2");
   water[3] = spriteSetRegister->find("Water3");
   coordsToPixel(_x, _y, getWorld()->getWaterLevel(), &waterX, &waterY);
//   int waterUp = water[waterFrame].get_sprite(waterSprite)->getFocusY();
//   int waterDown = water[waterFrame].get_sprite(waterSprite)->getH() - temp[square->get_kind()].get_sprite(sprite)->getFocusY();
//   int waterLeft = water[waterFrame].get_sprite(waterSprite)->getFocusX();
//   int waterRight = water[waterFrame].get_sprite(waterSprite)->getW() - temp[square->get_kind()].get_sprite(sprite)->getFocusX();
   int waterUp = 64;
   int waterDown = 64;
   int waterLeft = 64;
   int waterRight = 64;
   if (waterX + waterRight >= 0 &&
       waterY + waterDown >= 0 &&
       waterX - waterLeft < getW() &&
       waterY - waterUp < getH()) {
      waterSprite = -1;
      for (i = 0; i < 19; i++) {
         if ((wat[i].a == aa) &&
             (wat[i].b == bb) &&
             (wat[i].c == cc) &&
             (wat[i].d == dd)) {
            waterSprite = wat[i].sprite;
         }
      }
      if (waterSprite < 0) {
         allegro_exit();
         printf("Water\n");
         printf("aa = %d, bb = %d, cc = %d, dd = %d\n", aa, bb, cc, dd);
         printf("a = %d, b = %d, c = %d, d = %d\n", a, b, c, d);
         printf("_x = %d, _y = %d\n", _x, _y);
         exit(EXIT_FAILURE);
      }
      waterPoints = 0;
      (a <= getWorld()->getWaterLevel()) ? waterPoints++ : 1;
      (b <= getWorld()->getWaterLevel()) ? waterPoints++ : 1;
      (c <= getWorld()->getWaterLevel()) ? waterPoints++ : 1;
      (d <= getWorld()->getWaterLevel()) ? waterPoints++ : 1;
      if (waterPoints == 3) {
         water[waterFrame]->getSprite(waterSprite)->drawTrans(destination, waterX, waterY, &transMap);
         spritesDrawn++;
      }
      if (waterPoints == 4) {
         water[waterFrame]->getSprite(4)->drawTrans(destination, waterX, waterY, &transMap);
         spritesDrawn++;
      }
   }

}

int rect_overlap_test(const int x1, const int y1, const int x2, const int y2, const int x3, const int y3, const int x4, const int y4)
{
/*   if (x1 >= x3 && x1 <= x4) {
      if (y1 >= y3 && y1 <= y4) {
         return 1;
      }
   }
   if (x3 >= x1 && x3 <= x2) {
      if (y3 >= y1 && y3 <= y2) {
         return 1;
      }
   }

   if (x1 >= x3 && x1 <= x4) {
      if (y3 <= y1 && y4 >= y2) {
         return 1;
      }
   }
   if (x3 >= x1 && x3 <= x2) {
      if (y1 <= y3 && y2 >= y4) {
         return 1;
      }
   }

   return 0;*/
   return !((x1 < x3 && x2 < x3) ||
            (x1 > x4 && x2 > x4) ||
            (y1 < y3 && y2 < y3) ||
            (y1 > y4 && y2 > y4));
}

typedef struct SPRITE {
   int x;
   int y;
   int z;
   int light;
   bool wet;
   Sprite *sprite;
} SPRITE;

int spriteSort(const void *e1, const void *e2)
{
   if (((SPRITE *)e1)->z < ((SPRITE *)e2)->z) {
      return -1;
   }
   else if (((SPRITE *)e1)->z > ((SPRITE *)e2)->z) {
      return 1;
   }
   else {
      if (((SPRITE *)e1)->x < ((SPRITE *)e2)->x) {
         return -1;
      }
      else {
         return 1;
      }
   }
}

////////////////////////////////////////////////////////////////////////////////
// View Draw World
// Draws the world to the view image
////////////////////////////////////////////////////////////////////////////////
void View::drawWorld(BITMAP *const destination)
{
   int _x, _y;
   int screenX;
   int screenY;
   Object *object = NULL;
   int objectX, objectY;
   int i;

   squaresDrawn = 0;
   spritesDrawn = 0;
   objectsDrawn = 0;

   int centreX, centreY;
   double cx, cy;
//   pixelToSquare(getW() / 2 + getX(), getH() / 2 + getY(), &cx, &cy);
   pixelToSquareWithZ(getW() / 2 + getX(), getH() / 2 + getY(), &cx, &cy);
   centreX = (int)cx;
   centreY = (int)cy;
//   if (centreX < 0) centreX = 0;
//   else if (centreX >= world->getW()) centreX = world->getW() - 1;
//   if (centreY < 0) centreY = 0;
//   else if (centreY >= world->getH()) centreY = world->getH() - 1;
   int startX = centreX;
   int startY = centreY;

   int viewRows = (int)(getH() / (gameYPixelY + gameZPixelY));
   int viewColumns = (int)(getW() / (gameXPixelX + gameZPixelX));

   int above = -((viewRows / 2) + 3);
   int below = ((viewRows / 2) + 3);
   int left = -((viewColumns / 2) + 3);
   int right = ((viewColumns / 2) + 3);

   // Draw squares
   for (int row = above; row < below; row++) {
      for (int column = left; column < right; column++) {
         screenX = row + column;
         screenY = row + -column;
         if (((double)screenX / (double)2) == (screenX / 2) &&
             ((double)screenY / (double)2) == (screenY / 2)) {
            _x = startX + (screenX / 2);
            _y = startY + (screenY / 2);
            if ((_x >= 0) && (_x < getWorld()->getW()) && (_y >= 0) && (_y < getWorld()->getH())) {
               drawSquare(destination, _x, _y);
            }
         }
      }
   }

   // Draw objects
   int count = 0;
   ObjectList::iterator start = getWorld()->objects.begin();
   ObjectList::iterator finish = getWorld()->objects.end();
   while (start != finish) {
      object = (*start);
      coordsToPixel((*start)->getX(), (*start)->getY(), (*start)->getZ(), &objectX, &objectY);
      Sprite *sprite = NULL;
      if (object->getType() == OBJ_ACTIVE) {
         sprite = object->getAnimator()->getSprite();
      }
      else {
         sprite = spriteSetRegister->find("Tree")->getSprite(object->getKind());
      }
      if (objectX - sprite->getX() + sprite->getW() >= getX() &&
          objectX - sprite->getX() < getX() + getW() &&
          objectY - sprite->getY() + sprite->getH() >= getY() &&
          objectY - sprite->getY() < getY() + getH()) {
         count++;
      }
      start++;
   }
   SPRITE *sprites = new SPRITE[count];
   start = getWorld()->objects.begin();
   finish = getWorld()->objects.end();
   count = 0;
   while (start != finish) {
      object = (*start);
      coordsToPixel((*start)->getX(), (*start)->getY(), (*start)->getZ(), &objectX, &objectY);
      Sprite *sprite = NULL;
      if (object->getType() == OBJ_ACTIVE) {
         sprite = object->getAnimator()->getSprite();
      }
      else {
         sprite = spriteSetRegister->find("Tree")->getSprite(object->getKind());
      }
      if (objectX - sprite->getX() + sprite->getW() >= getX() &&
          objectX - sprite->getX() < getX() + getW() &&
          objectY - sprite->getY() + sprite->getH() >= getY() &&
          objectY - sprite->getY() < getY() + getH()) {
         sprites[count].x = objectX;
         sprites[count].y = objectY;
         sprites[count].z = (int)(object->getX() + object->getY());
         double objectDepth = object->getZ();
         int lightLevel = (int)(255 + ((objectDepth - getWorld()->getWaterLevel()) * 16));
         if (lightLevel > 255 || lightLevel < 0) {
            lightLevel = 0;
         }
         sprites[count].light = lightLevel;
         if (object->getZ() <= getWorld()->getWaterLevel()) {
            sprites[count].wet = true;
         }
         else {
            sprites[count].wet = false;
         }
         sprites[count].sprite = sprite;
         count++;
      }
      start++;
   }
   qsort(sprites, count, sizeof(SPRITE), spriteSort);

   // Draw objects
   for (i = 0; i < count; i++) {
      if (sprites[i].wet) {
         sprites[i].sprite->drawLit(destination, sprites[i].x, sprites[i].y, sprites[i].light, &lightMap);
      }
      else {
         sprites[i].sprite->draw(destination, sprites[i].x, sprites[i].y);
      }
      spritesDrawn++;
      objectsDrawn++;
   }

   delete [] sprites;
}
