////////////////////////////////////////////////////////////////////////////////
// Deity - By Carl Olsson 2003
// sprite.cpp Sprite, Spriteset and Anim classes
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "sprite.h"

////////////////////////////////////////////////////////////////////////////////
// Sprite Draw
// Draws the sprite
////////////////////////////////////////////////////////////////////////////////
void Sprite::draw(BITMAP *const destination, const int x, const int y)
{
//   BITMAP *drawBitmap = getBitmap();
//   bool drawBitmapMade = false;

//   if (bitmap_color_depth(destination) != bitmap_color_depth(getBitmap())) {
//      drawBitmapMade = true;
//      drawBitmap = create_bitmap(getBitmap()->w, getBitmap()->h);
//      clear_to_color(drawBitmap, bitmap_mask_color(drawBitmap));
//      draw_sprite(drawBitmap, getBitmap(), 0, 0);
////      blit(getBitmap(), drawBitmap, 0, 0, 0, 0, getBitmap()->w, getBitmap()->h);
//   }
//   draw_sprite(destination, drawBitmap, x - getX(), y - getY());
//   if (drawBitmapMade == true) {
//      destroy_bitmap(drawBitmap);
//   }
   draw_sprite(destination, getBitmap(), x - getX(), y - getY());
}

////////////////////////////////////////////////////////////////////////////////
// Sprite Draw Trans
// Draws the sprite transparently
////////////////////////////////////////////////////////////////////////////////
void Sprite::drawTrans(BITMAP *const destination, const int x, const int y, const COLOR_MAP *const map)
{
   BITMAP *drawBitmap = getBitmap();
   bool drawBitmapMade = false;
   COLOR_MAP *old = color_map;

   if (bitmap_color_depth(destination) != bitmap_color_depth(getBitmap())) {
      drawBitmapMade = true;
      drawBitmap = create_bitmap(getBitmap()->w, getBitmap()->h);
      clear_to_color(drawBitmap, bitmap_mask_color(drawBitmap));
      draw_sprite(drawBitmap, getBitmap(), 0, 0);
//      blit(getBitmap(), drawBitmap, 0, 0, 0, 0, getBitmap()->w, getBitmap()->h);
   }
   color_map = (COLOR_MAP *)map;
   set_trans_blender(0, 0, 0, 127);
   draw_trans_sprite(destination, drawBitmap, x - getX(), y - getY());
   color_map = old;
   if (drawBitmapMade == true) {
      destroy_bitmap(drawBitmap);
   }
}

////////////////////////////////////////////////////////////////////////////////
// Sprite Draw Lit
// Draws the sprite with lighting
////////////////////////////////////////////////////////////////////////////////
void Sprite::drawLit(BITMAP *const destination, const int x, const int y, const int lightLevel, const COLOR_MAP *const map)
{
   BITMAP *drawBitmap = getBitmap();
   bool drawBitmapMade = false;
   COLOR_MAP *old = color_map;
   int light;

   if (bitmap_color_depth(destination) != bitmap_color_depth(getBitmap())) {
      drawBitmapMade = true;
      drawBitmap = create_bitmap(getBitmap()->w, getBitmap()->h);
      clear_to_color(drawBitmap, bitmap_mask_color(drawBitmap));
      draw_sprite(drawBitmap, getBitmap(), 0, 0);
//      blit(getBitmap(), drawBitmap, 0, 0, 0, 0, getBitmap()->w, getBitmap()->h);
   }
   light = lightLevel;
   if (bitmap_color_depth(destination) != 8) {
      light = abs(light - 255);
   }
   color_map = (COLOR_MAP *)map;
   set_trans_blender(0, 0, 0, 127);
   draw_lit_sprite(destination, drawBitmap, x - getX(), y - getY(), lightLevel);
   color_map = old;
   if (drawBitmapMade == true) {
      destroy_bitmap(drawBitmap);
   }
}
