////////////////////////////////////////////////////////////////////////////////
// Deity - By Carl Olsson 2000
// object.h Object class
////////////////////////////////////////////////////////////////////////////////

#ifndef _OBJECT_H // Check if file allready included
#define _OBJECT_H

#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "doublist.h"
#include "sprite.h"

// Object Types
#define OBJ_STATIC 0
#define OBJ_ACTIVE 1

class Object {
public:
   Object(void) : x(0), y(0), z(0), deltaX(0), deltaY(0), deltaZ(0), type(0), kind(0), direction(0) {}
   ~Object(void) {}

   void setX(double _x) { x = _x; }
   double getX(void) { return x; }
   void setY(double _y) { y = _y; }
   double getY(void) { return y; }
   void setZ(double _z) { z = _z; }
   double getZ(void) { return z; }

   void setDeltaX(double _deltaX) { deltaX = _deltaX; }
   double getDeltaX(void) { return deltaX; }
   void setDeltaY(double _deltaY) { deltaY = _deltaY; }
   double getDeltaY(void) { return deltaY; }
   void setDeltaZ(double _deltaZ) { deltaZ = _deltaZ; }
   double getDeltaZ(void) { return deltaZ; }

   void setType(int _type) { type = _type; }
   int getType(void) { return type; }

   void setKind(int _kind) { kind = _kind; }
   int getKind(void) { return kind; }

   void setDirection(int _direction) { direction = _direction; }
   int getDirection(void) { return direction; }
   void update(void);
   Animator *getAnimator(void) { return &animator; }
private:
   double x, y, z;
   double deltaX, deltaY, deltaZ;
   int type;
   int kind;
   int direction;
   Animator animator;
};

class ObjectList : public DoubleList<Object> {
public:
   void sort(void);
};

#endif // _OBJECT_H
