////////////////////////////////////////////////////////////////////////////////
// Deity - By Carl Olsson 2000
// view.h View class
////////////////////////////////////////////////////////////////////////////////

#ifndef _VIEW_H
#define _VIEW_H

#include <allegro.h>
#include "world.h"

class Interface;

class View {
public:
   View(void) : x(0), y(0), w(0), h(0), offsetX(0), offsetY(0), focusX(0), focusY(0), focusZ(0), cursorX(0), cursorY(0), cursorMode(0), cursorColour(0), cursorColourState(true), cursorColourWait(0) {}
   ~View(void) {}

   int getX(void) { return x; }
   void setX(const int _x) { x = _x; }
   int getY(void) { return y; }
   void setY(const int _y) { y = _y; }
   int getW(void) { return w; }
   int getH(void) { return h; }
   void setW(const int _w) { w = _w; }
   void setH(const int _h) { h = _h; }
   int getOffsetX(void) { return offsetX; }
   void setOffsetX(const int _offsetX) { offsetX = _offsetX; }
   int getOffsetY(void) { return offsetY; }
   void setOffsetY(const int _offsetY) { offsetY = _offsetY; }
   void set(const int _x, const int _y, const int _w, const int _h, const int _offsetX, const int _offsetY) { setX(_x); setY(_y); setW(_w); setH(_h); setOffsetX(_offsetX); setOffsetY(_offsetY); }

   double getFocusX(void) { return focusX; }
   void setFocusX(const double _focusX) { focusX = _focusX; }
   double getFocusY(void) { return focusY; }
   void setFocusY(const double _focusY) { focusY = _focusY; }
   double getFocusZ(void) { return focusZ; }
   void setFocusZ(const double _focusZ) { focusZ = _focusZ; }
   void setFocus(const double _focusX, const double _focusY, const double _focusZ) { setFocusX(_focusX); setFocusY(_focusY); setFocusZ(_focusZ); }

   World *getWorld(void);

   void draw(BITMAP *const destination);
   void drawWorld(BITMAP *const destination);
   void drawSquare(BITMAP *const destination, int _x, int _y);
   void drawOverlay(BITMAP *const destination);
   void drawSquareHighlight(BITMAP *const destination, int _x, int _y);
   void drawPointCursor(BITMAP *const destination, int _x, int _y);
   void drawSquareCursor(BITMAP *const destination, int _x, int _y);

   void pixelToSquare(const double pixelX, const double pixelY, double *const squareX, double *const squareY);
   void pixelToSquareWithZ(const double pixelX, const double pixelY, double *const squareX, double *const squareY);
   void pixelToPointWithZ(const double pixelX, const double pixelY, double *const squareX, double *const squareY);
   void squareToPixel(const double squareX, const double squareY, int *const pixelX, int *const pixelY);
   void coordsToPixel(const double coordsX, const double coordsY, const double coordsZ, int *const pixelX, int *const pixelY);

   bool pixelInSquare(const int pixelX, const int pixelY, const int squareX, const int squareY);
   bool pixelInPoint(const int pixelX, const int pixelY, const int squareX, const int squareY);

   void viewToScreen(const double viewX, const double viewY, double *const screenX, double *const screenY);
   void screenToView(const double screenX, const double screenY, double *const viewX, double *const viewY);
   void screenToGame(const double screenX, const double screenY, double *const gameX, double *const gameY);
   void screenToGame(const double screenX, const double screenY, double *const gameX, double *const gameY, double *const gameZ);
   void gameToScreen(const double gameX, const double gameY, const double gameZ, double *const screenX, double *const screenY);
   void gameToView(const double gameX, const double gameY, const double gameZ, double *const viewX, double *const viewY);
   void viewToGame(const double viewX, const double viewY, double *const gameX, double *const gameY, double *const gameZ);
   void viewToGamePoint(const double viewX, const double viewY, double *const gameX, double *const gameY, double *const gameZ);
   void viewToGame(const double viewX, const double viewY, double *const gameX, double *const gameY);

   void setSpatialRelationship(const double _gameXPixelX, const double _gameXPixelY, const double _gameYPixelX, const double _gameYPixelY, const double _gameZPixelX, const double _gameZPixelY) {
      gameXPixelX = _gameXPixelX;
      gameXPixelY = _gameXPixelY;
      gameYPixelX = _gameYPixelX;
      gameYPixelY = _gameYPixelY;
      gameZPixelX = _gameZPixelX;
      gameZPixelY = _gameZPixelY;
   }
   double getGameXPixelX(void) { return gameXPixelX; }
   double getGameXPixelY(void) { return gameXPixelY; }
   double getGameYPixelX(void) { return gameYPixelX; }
   double getGameYPixelY(void) { return gameYPixelY; }
   double getGameZPixelX(void) { return gameZPixelX; }
   double getGameZPixelY(void) { return gameZPixelY; }
   void setInterface(Interface *_interface) { interface = _interface; }
   Interface *getInterface(void) { return interface; }
   void setCursorMode(const int _cursorMode) { cursorMode = _cursorMode; }
   int getCursorMode(void) { return cursorMode; }
   void setCursorX(const int _cursorX) { cursorX = _cursorX; }
   void setCursorY(const int _cursorY) { cursorY = _cursorY; }
   int getCursorX(void) { return cursorX; }
   int getCursorY(void) { return cursorY; }
private:
   int x;
   int y;
   int w;
   int h;
   int offsetX;
   int offsetY;
   double focusX;
   double focusY;
   double focusZ;
   double gameXPixelX;
   double gameXPixelY;
   double gameYPixelX;
   double gameYPixelY;
   double gameZPixelX;
   double gameZPixelY;
   int cursorX;
   int cursorY;
   int cursorMode;
public:
   int cursorColour;
   bool cursorColourState;
   int cursorColourWait;
private:
   Interface *interface;
};

extern int spritesDrawn;
extern int objectsDrawn;
extern int squaresDrawn;

#endif // _VIEW_H
