////////////////////////////////////////////////////////////////////////////////
// Deity - By Carl Olsson 2003
// object.cpp Object class
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <allegro.h>
#include "main.h"
#include "object.h"
#include "world.h"

#include <math.h>

#ifndef M_PI
   #define M_PI 3.141592654
#endif

void ObjectList::sort(void)
{
   ObjectList *temp;
   Object *object = NULL;
   int xy = 0;

   int b_c = 0;
   int a_c = 0;
   int d_c = 0;
   int t_c = 0;
   int o_c = 0;

   b_c = count();

   temp = new ObjectList;

   while (head.next != &tail) {
      xy++;
      ObjectList::iterator start = begin();
      ObjectList::iterator finish = end();
      while (start != finish) {
         object = (*start);
         if (object->getX() + object->getY() < xy) {
            temp->push(object);
            start.remove();
         }
         else {
            start++;
         }
      }
   }

   d_c = count();
   t_c = temp->count();

   ObjectList::iterator start = temp->begin();
   ObjectList::iterator finish = temp->end();
   while (start != finish) {
      object = (*start);
      push(object);
      start.remove();
      o_c++;
   }

   a_c = count();

   if (b_c != a_c || a_c != t_c || b_c != t_c) {
      allegro_exit();
      printf("\nb_c: %d\n", b_c);
      printf("\na_c: %d\n", a_c);
      printf("\nd_c: %d\n", d_c);
      printf("\nt_c: %d\n", t_c);
      printf("\no_c: %d\n", o_c);
      exit(69);
   }

   delete temp;
}

typedef struct DIR_TO_ANIM {
   char *anim;
   int dir;
} DIR_TO_ANIM;

DIR_TO_ANIM dir_to_anim[] = {
 { "N",  0 },
 { "NE", 1 },
 { "E",  2 },
 { "SE", 3 },
 { "S",  4 },
 { "SW", 5 },
 { "W",  6 },
 { "NW", 7 },
 { NULL, 0 }
};

void Object::update(void)
{
   char buffer[256];
   int i;
   int dir = -1;
   char *suffix = NULL;
   
   if (getType() == OBJ_ACTIVE) {
      if ((rand() % 50) == 0) {
         float angle = (float)rand() / (float)RAND_MAX * 2 * M_PI;
         float speed = 0.03125;
         setDeltaX(cos(angle) * speed);
         setDeltaY(sin(angle) * speed);
      }

      animator.shift(1);

      float arc = (2 * M_PI) / 8;
      float angle = atan2(getDeltaY(), getDeltaX());
      angle = angle + arc / 2;
      while (angle < 0.0) angle += 2 * M_PI;
      while (angle >= 2 * M_PI) angle -= 2 * M_PI;
      if      (angle >= (0 * arc) && angle < (1 * arc)) {
         setDirection(2);
      }
      else if (angle >= (1 * arc) && angle < (2 * arc)) {
         setDirection(3);
      }
      else if (angle >= (2 * arc) && angle < (3 * arc)) {
         setDirection(4);
      }
      else if (angle >= (3 * arc) && angle < (4 * arc)) {
         setDirection(5);
      }
      else if (angle >= (4 * arc) && angle < (5 * arc)) {
         setDirection(6);
      }
      else if (angle >= (5 * arc) && angle < (6 * arc)) {
         setDirection(7);
      }
      else if (angle >= (6 * arc) && angle < (7 * arc)) {
         setDirection(0);
      }
      else if (angle >= (7 * arc) && angle < (8 * arc)) {
         setDirection(1);
      }

      setX(getX() + getDeltaX());
      setY(getY() + getDeltaY());
   }
   else {
      setDirection(0);
   }

   for (i = 0; dir_to_anim[i].anim != NULL; i++) {
      if (dir_to_anim[i].dir == getDirection()) {
         dir = i;
         break;
      }
   }

   if (dir >= 0) {
      suffix = dir_to_anim[dir].anim;
   }
   else {
      suffix = dir_to_anim[0].anim;
   }
   strcpy(buffer, "Human");
   strcat(buffer, suffix);
   animator.setAnim(animRegister->find(buffer));

   // X
   if (getX() < 0) {
      setX(0);
   }
   if (getX() > objectWorld->getW()) {
      setX(objectWorld->getW());
   }

   // Y
   if (getY() < 0) {
      setY(0);
   }
   if (getY() > objectWorld->getH()) {
      setY(objectWorld->getH());
   }

   setZ(objectWorld->getZ(getX(), getY()));
}
