////////////////////////////////////////////////////////////////////////////////
// Deity - By Carl Olsson 2000
// input.h Input class
////////////////////////////////////////////////////////////////////////////////

#ifndef _INPUT_H
#define _INPUT_H

#include "view.h"

class Interface;

#define BUILD_SQUARE  0
#define BUILD_DIAMOND 1

#define SINGLE_CLICK 1
#define DOUBLE_CLICK 2
#define DRAG         3

class Input {
public:
   Input(void);
   ~Input(void);
   void process(void);
   void poll(void);

   int leftClick;
   int rightClick;
   int leftState;
   int rightState;
   int mouseX;
   int mouseY;
   int mouseChangeX;
   int mouseChangeY;
   int mouseMickeysX;
   int mouseMickeysY;

   bool keyPress[128];
   bool keyState[128];
   int keyWait[128];
   int keyShift;
   void setInterface(Interface *const _interface) { interface = _interface; }
   Interface *getInterface(void) { return interface; }

   World *getWorld(void);
private:
   Interface *interface;
};

extern int leftDoubleClick;
extern int leftSingleClick;
extern int leftDrag;
extern int rightDoubleClick;
extern int rightSingleClick;
extern int rightDrag;

extern int buildMode;
extern int viewMode;

#endif // _INPUT_H
