#ifndef _APPLICATION_H
#define _APPLICATION_H

#include <stdlib.h>

#include "world.h"
#include "interface.h"
#include "display.h"

class Application {
public:
   Application(void) : display(NULL), interface(this), exitFlag(false), paused(false) {}
   ~Application(void) {}
   void processArguments(int argc, char *argv[]) {}
   void startup(void);
   void shutdown(void);
   int run(void);
   void forceDraw(void);
   Display *getDisplay(void) { return display; }
   void setPaused(const bool _paused) { paused = _paused; }
   bool getPaused(void) { return paused; }
   void setExitFlag(const bool _exitFlag) { exitFlag = _exitFlag; }
   bool getExitFlag(void) { return exitFlag; }
   void drawInfo(BITMAP *destination, World *world, View *view, int _x, int _y, int _w, int _h);
   int titleScreen(void);
private:
   Display *display;
   Interface interface;
   bool exitFlag;
   bool paused;
public:
   DATAFILE *gameData;
   PALETTE *gamePalette;
   FONT *gameFont;
   FONT *gameFontSmall;
   FONT *gameFontLarge;
};

#define GAME_TITLE   "Deity"
#define GAME_VERSION 0.01
#define GAME_STAGE   0

#endif // _APPLICATION_H
