////////////////////////////////////////////////////////////////////////////////
// Deity - By Carl Olsson 2003
// world.cpp World class
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "world.h"
#include "main.h"
#include "misc.h"
#include "input.h"

World *objectWorld = NULL;

#define LIMIT(value, lower, upper) ((value < lower) ? lower : ((value > upper) ? upper : value))

double World::getZ(double _x, double _y)
{
   int a = getPointZ(LIMIT((int)_x + 0, 0, getW()), LIMIT((int)_y + 0, 0, getH()));
   int b = getPointZ(LIMIT((int)_x + 1, 0, getW()), LIMIT((int)_y + 0, 0, getH()));
   int c = getPointZ(LIMIT((int)_x + 1, 0, getW()), LIMIT((int)_y + 1, 0, getH()));
   int d = getPointZ(LIMIT((int)_x + 0, 0, getW()), LIMIT((int)_y + 1, 0, getH()));

   double sX = _x - (int)_x;
   double sY = _y - (int)_y;

   double zNorth = ((double)(b - a) * sX) + (double)a;
   double zSouth = ((double)(c - d) * sX) + (double)d;
   return ((zSouth - zNorth) * sY) + zNorth;
}

int World::getPointZ(int _x, int _y)
{
   return getPoint(_x, _y)->getZ();
}

////////////////////////////////////////////////////////////////////////////////
// World Populate
// Fills the world with objects
////////////////////////////////////////////////////////////////////////////////
void World::populate(int activeCount, int staticCount)
{
   Object *object = NULL;
   int i;
   int placed;
   int tries;

   for (i = 0; i < activeCount; i++) {
      object = new Object;
      object->setType(OBJ_ACTIVE);
      object->setX(((double)rand() / (double)RAND_MAX) * (getW() - 1));
      object->setY(((double)rand() / (double)RAND_MAX) * (getH() - 1));
      object->setZ(getZ(object->getX(), object->getY()));
      object->getAnimator()->setAnim(animRegister->find("HumanS"));
      objects.push(object);
   }
   for (i = 0; i < staticCount; i++) {
      object = new Object;
      object->setType(OBJ_STATIC);
      object->setKind(rand() % 10);
      placed = FALSE;
      tries = 0;
      while ((placed != TRUE) && (tries < 100)) {
         double x = ((double)rand() / (double)RAND_MAX) * (getW() - 1);
         double y = ((double)rand() / (double)RAND_MAX) * (getH() - 1);
         if ((int)x == getW() || (int)y == getH()) {////////////
            while (!mouse_b) {//////////////
               textprintf(screen, font, 0, 0, rand() % 256, "Argh! Object not in world!");/////////
            }//////////////
         }///////////
         object->setX(x);
         object->setY(y);
         object->setZ(getZ(object->getX(), object->getY()));
         int zAvg = (getPoint((int)x + 0, (int)y + 0)->getZ() + getPoint((int)x + 1, (int)y + 0)->getZ() + getPoint((int)x + 0, (int)y + 1)->getZ() + getPoint((int)x + 1, (int)y + 1)->getZ()) / 4;
         if (object->getKind() < 8) {
            if (zAvg > 0) {
               objects.push(object);
               placed = TRUE;
            }
         }
         else if (object->getKind() < 10) {
            if (zAvg == 0) {
               objects.push(object);
               placed = TRUE;
            }
         }
         tries++;
      }
      if (placed == FALSE) {
         delete object;
      }
   }
}

////////////////////////////////////////////////////////////////////////////////
// World Populate
// Empties the world of objects
////////////////////////////////////////////////////////////////////////////////
void World::depopulate(void)
{
   Object *object = NULL;

   ObjectList::iterator start = objects.begin();
   ObjectList::iterator finish = objects.end();
   while (start != finish) {
      object = (*start);
      start.remove();
      delete object;
   }
}

////////////////////////////////////////////////////////////////////////////////
// World Process
// Processes the entire world
////////////////////////////////////////////////////////////////////////////////
void World::update(void)
{
   int x;
   int y;

   // Process all objects
   ObjectList::iterator start = objects.begin();
   ObjectList::iterator finish = objects.end();
   while (start != finish) {
      objectWorld = this;
      (*start)->update();
      start++;
   }

   // Process all squares
   for (x = 0; x < getW(); x++) {
      for (y = 0; y < getH(); y++) {
         updateSquare(x, y);
      }
   }
}

////////////////////////////////////////////////////////////////////////////////
// World Process Square
// Processes a square
////////////////////////////////////////////////////////////////////////////////
void World::updateSquare(int x, int y)
{
}

////////////////////////////////////////////////////////////////////////////////
// World Create Square
// Creates the square map
////////////////////////////////////////////////////////////////////////////////
void *World::createSquares(void)
{
   int x, y;

   // Allocate square array
   squares = new Square[getW() * getH()];

   // Initialise square array
   for (x = 0; x < getW(); x++) {
      for (y = 0; y < getH(); y++) {
         getSquare(x, y)->setKind(0);
      }
   }

   return squares;
}

////////////////////////////////////////////////////////////////////////////////
// World Destroy Square
// Destroys the square map
////////////////////////////////////////////////////////////////////////////////
void *World::destroySquares(void)
{
   // Free square array
   delete [] squares;

   return squares;
}

////////////////////////////////////////////////////////////////////////////////
// World Create Points
// Creates the point map
////////////////////////////////////////////////////////////////////////////////
void *World::createPoints(void)
{
   int x, y;

   // Allocate point array
   points = new Point[(getW() + 1) * (getH() + 1)];

   // Initialise point array
   for (x = 0; x < (getW() + 1); x++) {
      for (y = 0; y < (getH() + 1); y++) {
         getPoint(x, y)->setZ(0);
      }
   }

   return points;
}

////////////////////////////////////////////////////////////////////////////////
// World Destroy Points
// Destroys the point map
////////////////////////////////////////////////////////////////////////////////
void *World::destroyPoints(void)
{
   // Free point array
   delete [] points;

   return points;
}

////////////////////////////////////////////////////////////////////////////////
// World Constructor
// Initiaises World class
////////////////////////////////////////////////////////////////////////////////
World::World(void)
{
   w = 0;
   h = 0;
   squares = NULL;
   points = NULL;
   waterLevel = 0;
}

////////////////////////////////////////////////////////////////////////////////
// World Constructor
// Initiaises World class
////////////////////////////////////////////////////////////////////////////////
World::World(int _w, int _h)
{
   w = 0;
   h = 0;
   squares = NULL;
   points = NULL;
   waterLevel = 0;
   setW(_w);
   setH(_h);
   if (createPoints() == NULL) {
      allegro_exit();
      perror("Fail createPoints");
      exit(EXIT_FAILURE);
   }
   if (createSquares() == NULL) {
      perror("Fail createSquares");
      exit(EXIT_FAILURE);
   }
}

////////////////////////////////////////////////////////////////////////////////
// World Destructor
// Deinitiaises World class
////////////////////////////////////////////////////////////////////////////////
World::~World()
{
   destroyPoints();
   destroySquares();
}

////////////////////////////////////////////////////////////////////////////////
// World Get Point
// Returns a point from the point map
////////////////////////////////////////////////////////////////////////////////
Point *World::getPoint(int _x, int _y)
{
   if ((_x < 0) || (_x >= getW() + 1) || (_y < 0) || (_y >= getH() + 1)) {
      return NULL;
   }
   else {
      return &points[_x + (_y * (getW() + 1))];
   }
}

////////////////////////////////////////////////////////////////////////////////
// World Get Square
// Returns a square from the square map
////////////////////////////////////////////////////////////////////////////////
Square *World::getSquare(int _x, int _y)
{
   if ((_x < 0) || (_x >= getW()) || (_y < 0) || (_y >= getH())) {
      return NULL;
   }
   else {
      return &squares[_x + (_y * getW())];
   }
}

////////////////////////////////////////////////////////////////////////////////
// World Raise Square
// Raises a point using square method
////////////////////////////////////////////////////////////////////////////////
void World::raiseSquare(int _x, int _y, int amount)
{
   int _z;
   Point *point = NULL;

   if ((_x < 0) || (_x >= getW() + 1) || (_y < 0) || (_y >= getH() + 1)) {
      error("Point out of range", EXIT_FAILURE);
   }

   if ((point = getPoint(_x, _y)) != NULL) {
      _z = point->getZ() + amount;
      raisePointSquare(_x, _y, _z);
   }
}

////////////////////////////////////////////////////////////////////////////////
// World Raise Point Square
// Sets a point using square method
////////////////////////////////////////////////////////////////////////////////
void World::raisePointSquare(int _x, int _y, int _z)
{
   Point *point = NULL;
//   int offsetX = 0, offsetY = 0;

   if ((_x < 0) || (_x >= getW() + 1) || (_y < 0) || (_y >= getH() + 1)) {
      error("Point out of range", EXIT_FAILURE);
   }

   if ((point = getPoint(_x, _y)) != NULL) {
      point->setZ(_z);
   }
   else {
      return;
   }

/*   for (offsetX = -1; offsetX < 2; offsetX++) {
      for (offsetY = -1; offsetY < 2; offsetY++) {
         if (offsetX == 0 && offsetY == 0) {
         }
         else {
            point = getPoint(_x + offsetX, _y + offsetY);
            if (point != NULL) {
               if (point->getZ() < _z - 1) {
                  raisePointSquare(_x + offsetX, _y + offsetY, _z - 1);
               }
            }
         }
      }
   }*/

   point = getPoint(_x - 1, _y - 1);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointSquare(_x - 1, _y - 1, _z - 1);
      }
   }
   point = getPoint(_x + 0, _y - 1);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointSquare(_x + 0, _y - 1, _z - 1);
      }
   }
   point = getPoint(_x + 1, _y - 1);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointSquare(_x + 1, _y - 1, _z - 1);
      }
   }
   point = getPoint(_x - 1, _y + 0);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointSquare(_x - 1, _y + 0, _z - 1);
      }
   }
   point = getPoint(_x + 1, _y + 0);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointSquare(_x + 1, _y + 0, _z - 1);
      }
   }
   point = getPoint(_x - 1, _y + 1);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointSquare(_x - 1, _y + 1, _z - 1);
      }
   }
   point = getPoint(_x + 0, _y + 1);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointSquare(_x + 0, _y + 1, _z - 1);
      }
   }
   point = getPoint(_x + 1, _y + 1);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointSquare(_x + 1, _y + 1, _z - 1);
      }
   }

   return;
}

////////////////////////////////////////////////////////////////////////////////
// World Lower Square
// Lowers a point using square method
////////////////////////////////////////////////////////////////////////////////
void World::lowerSquare(int _x, int _y, int amount)
{
   int _z;
   Point *point = NULL;

   if ((_x < 0) || (_x >= getW() + 1) || (_y < 0) || (_y >= getH() + 1)) {
      error("Point out of range", EXIT_FAILURE);
   }

   if ((point = getPoint(_x, _y)) != NULL) {
      _z = point->getZ() - amount;
      lowerPointSquare(_x, _y, _z);
   }
}

////////////////////////////////////////////////////////////////////////////////
// World Lower Point Square
// Sets a point using square method
////////////////////////////////////////////////////////////////////////////////
void World::lowerPointSquare(int _x, int _y, int _z)
{
   Point *point = NULL;
//   int offsetX = 0, offsetY = 0;

   if ((_x < 0) || (_x >= getW() + 1) || (_y < 0) || (_y >= getH() + 1)) {
      error("Point out of range", EXIT_FAILURE);
   }

   if ((point = getPoint(_x, _y)) != NULL) {
      point->setZ(_z);
   }
   else {
      return;
   }

/*   for (offsetX = -1; offsetX < 2; offsetX++) {
      for (offsetY = -1; offsetY < 2; offsetY++) {
         if (offsetX == 0 && offsetY == 0) {
         }
         else {
            point = getPoint(_x + offsetX, _y + offsetY);
            if (point != NULL) {
               if (point->getZ() > _z + 1) {
                  lowerPointSquare(_x + offsetX, _y + offsetY, _z + 1);
               }
            }
         }
      }
   }*/

   point = getPoint(_x - 1, _y - 1);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointSquare(_x - 1, _y - 1, _z + 1);
      }
   }
   point = getPoint(_x + 0, _y - 1);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointSquare(_x + 0, _y - 1, _z + 1);
      }
   }
   point = getPoint(_x + 1, _y - 1);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointSquare(_x + 1, _y - 1, _z + 1);
      }
   }
   point = getPoint(_x - 1, _y + 0);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointSquare(_x - 1, _y + 0, _z + 1);
      }
   }
   point = getPoint(_x + 1, _y + 0);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointSquare(_x + 1, _y + 0, _z + 1);
      }
   }
   point = getPoint(_x - 1, _y + 1);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointSquare(_x - 1, _y + 1, _z + 1);
      }
   }
   point = getPoint(_x + 0, _y + 1);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointSquare(_x + 0, _y + 1, _z + 1);
      }
   }
   point = getPoint(_x + 1, _y + 1);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointSquare(_x + 1, _y + 1, _z + 1);
      }
   }

   return;
}

////////////////////////////////////////////////////////////////////////////////
// World Raise Diamond
// Raises a point using diamond method
////////////////////////////////////////////////////////////////////////////////
void World::raiseDiamond(int _x, int _y, int amount)
{
   int _z;
   Point *point = NULL;

   if ((_x < 0) || (_x >= getW() + 1) || (_y < 0) || (_y >= getH() + 1)) {
      error("Point out of range", EXIT_FAILURE);
   }

   if ((point = getPoint(_x, _y)) != NULL) {
      _z = point->getZ() + amount;
      raisePointDiamond(_x, _y, _z);
   }
}

////////////////////////////////////////////////////////////////////////////////
// World Raise Diamond
// Sets a point using diamond method
////////////////////////////////////////////////////////////////////////////////
void World::raisePointDiamond(int _x, int _y, int _z)
{
   Point *point = NULL;
//   int offsetX = 0, offsetY = 0;
//   int offsetBaseX = 0, offsetBaseY = 0;

   if ((_x < 0) || (_x >= getW() + 1) || (_y < 0) || (_y >= getH() + 1)) {
      error("Point out of range", EXIT_FAILURE);
   }

   if ((point = getPoint(_x, _y)) != NULL) {
      point->setZ(_z);
   }
   else {
      return;
   }

/*   for (offsetBaseX = 0; offsetBaseX < 2; offsetBaseX++) {
      for (offsetBaseY = 0; offsetBaseY < 2; offsetBaseY++) {
         offsetX = (offsetBaseX * 1) + (offsetBaseY * 1) - 1;
         offsetY = (offsetBaseX * -1) + (offsetBaseY * 1);
         point = getPoint(_x + offsetX, _y + offsetY);
         if (point != NULL) {
            if (point->getZ() < _z - 1) {
               raisePointDiamond(_x + offsetX, _y + offsetY, _z - 1);
            }
         }
      }
   }*/

   point = getPoint(_x + 0, _y - 1);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointDiamond(_x + 0, _y - 1, _z - 1);
      }
   }
   point = getPoint(_x - 1, _y + 0);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointDiamond(_x - 1, _y + 0, _z - 1);
      }
   }
   point = getPoint(_x + 1, _y + 0);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointDiamond(_x + 1, _y + 0, _z - 1);
      }
   }
   point = getPoint(_x + 0, _y + 1);
   if (point != NULL) {
      if (point->getZ() < _z - 1) {
         raisePointDiamond(_x + 0, _y + 1, _z - 1);
      }
   }

   return;
}

////////////////////////////////////////////////////////////////////////////////
// World Lower Diamond
// Lowers a point using diamond method
////////////////////////////////////////////////////////////////////////////////
void World::lowerDiamond(int _x, int _y, int amount)
{
   int _z;
   Point *point = NULL;

   if ((_x < 0) || (_x >= getW() + 1) || (_y < 0) || (_y >= getH() + 1)) {
      error("Point out of range", EXIT_FAILURE);
   }

   if ((point = getPoint(_x, _y)) != NULL) {
      _z = point->getZ() - amount;
      lowerPointDiamond(_x, _y, _z);
   }
}

////////////////////////////////////////////////////////////////////////////////
// World Lower Diamond
// Sets a point using diamond method
////////////////////////////////////////////////////////////////////////////////
void World::lowerPointDiamond(int _x, int _y, int _z)
{
   Point *point = NULL;
//   int offsetX = 0, offsetY = 0;
//   int offsetBaseX = 0, offsetBaseY = 0;

   if ((_x < 0) || (_x >= getW() + 1) || (_y < 0) || (_y >= getH() + 1)) {
      error("Point out of range", EXIT_FAILURE);
   }

   if ((point = getPoint(_x, _y)) != NULL) {
      point->setZ(_z);
   }
   else {
      return;
   }

/*   for (offsetBaseX = 0; offsetBaseX < 2; offsetBaseX++) {
      for (offsetBaseY = 0; offsetBaseY < 2; offsetBaseY++) {
         offsetX = (offsetBaseX * 1) + (offsetBaseY * 1) - 1;
         offsetY = (offsetBaseX * -1) + (offsetBaseY * 1);
         point = getPoint(_x + offsetX, _y + offsetY);
         if (point != NULL) {
            if (point->getZ() > _z + 1) {
               lowerPointDiamond(_x + offsetX, _y + offsetY, _z + 1);
            }
         }
      }
   }*/

   point = getPoint(_x + 0, _y - 1);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointDiamond(_x + 0, _y - 1, _z + 1);
      }
   }
   point = getPoint(_x - 1, _y + 0);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointDiamond(_x - 1, _y + 0, _z + 1);
      }
   }
   point = getPoint(_x + 1, _y + 0);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointDiamond(_x + 1, _y + 0, _z + 1);
      }
   }
   point = getPoint(_x + 0, _y + 1);
   if (point != NULL) {
      if (point->getZ() > _z + 1) {
         lowerPointDiamond(_x + 0, _y + 1, _z + 1);
      }
   }

   return;
}

////////////////////////////////////////////////////////////////////////////////
// World Generate Point Map
// Generates point map portion of terrain
////////////////////////////////////////////////////////////////////////////////
void World::generatePointMap(int roughness, int magnitude)
{
   int i, j;

   for (i = magnitude; i > 0; i--) {
      for (j = 0; j < roughness; j++) {
         lowerSquare(rand() % (getW() + 1), rand() % (getH() + 1), rand() % magnitude);
         lowerDiamond(rand() % (getW() + 1), rand() % (getH() + 1), rand() % magnitude);
         raiseSquare(rand() % (getW() + 1), rand() % (getH() + 1), rand() % magnitude);
         raiseDiamond(rand() % (getW() + 1), rand() % (getH() + 1), rand() % magnitude);
      }
   }
}

////////////////////////////////////////////////////////////////////////////////
// World Generate Square Map
// Generates square map portion of terrain
////////////////////////////////////////////////////////////////////////////////
void World::generateSquareMap(void)
{
   int _x, _y;
   int points;

   for (_x = 0; _x < getW(); _x++) {
      for (_y = 0; _y < getH(); _y++) {
         if (rand() % 8 == 0) {
            getSquare(_x, _y)->setKind(1);
         }
         else {
            getSquare(_x, _y)->setKind(0);
         }
      }
   }
   for (_x = 0; _x < getW(); _x++) {
      for (_y = 0; _y < getH(); _y++) {
         points = 0;
         if (getPoint(_x + 0, _y + 0)->getZ() <= 0) points++;
         if (getPoint(_x + 1, _y + 0)->getZ() <= 0) points++;
         if (getPoint(_x + 1, _y + 1)->getZ() <= 0) points++;
         if (getPoint(_x + 0, _y + 1)->getZ() <= 0) points++;
         if (points > 0) {
            getSquare(_x, _y)->setKind(2);
         }
      }
   }
}

