////////////////////////////////////////////////////////////////////////////////
// Deity - By Carl Olsson 2000
// register.h Register class
////////////////////////////////////////////////////////////////////////////////

#ifndef __REGISTER_H
#define __REGISTER_H

#include "doublist.h"

template <class T>
class Register {
public:
   class RegisterList : public DoubleList<T> {};
   Register(void);
   ~Register(void);
   void add(T *item);
   void remove(T *item);
   T *find(char *name);
   char *name(T *item);
   void display(void);
   RegisterList *getList(void) { return &list; }
private:
   RegisterList list;
};

template <class T>
Register<T>::Register(void)
{
}

template <class T>
Register<T>::~Register(void)
{
   RegisterList::iterator current = list.begin();
   RegisterList::iterator end = list.end();
   while (current != end) {
      delete current.remove();
   }
}

template <class T>
void Register<T>::add(T *item)
{
   list.push(item);
}

template <class T>
void Register<T>::remove(T *item)
{
   list.pop(item);
}

template <class T>
T *Register<T>::find(char *name)
{
   RegisterList::iterator current = list.begin();
   RegisterList::iterator end = list.end();
   while (current != end) {
      if (strcmp((*current)->getName(), name) == 0) {
         return (*current);
      }
      current++;
   }
   return NULL;
}

template <class T>
char *Register<T>::name(T *item)
{
   RegisterList::iterator current = list.begin();
   RegisterList::iterator end = list.end();
   while (current != end) {
      if ((*current) == item) {
         return (*current)->getName();
      }
      current++;
   }
   return NULL;
}

template <class T>
void Register<T>::display(void)
{
   RegisterList::iterator current = list.begin();
   RegisterList::iterator end = list.end();
   while (current != end) {
      printf("%s\n", (*current)->getName());
      current++;
   }
}

#endif // __REGISTER_H
