////////////////////////////////////////////////////////////////////////////////
// Deity - By Carl Olsson 2003
// misc.cpp Miscelaneous functions
////////////////////////////////////////////////////////////////////////////////

#include "misc.h"
#include <allegro.h>
#include <stdio.h>
#include <string.h>

////////////////////////////////////////////////////////////////////////////////
// Interpolate
// Finds a location between two points in 1D space
////////////////////////////////////////////////////////////////////////////////
float interpolate1d(float start, float finish, float position)
{
   float location;

   location = ((finish - start) * position) + start;

   return location;
}

////////////////////////////////////////////////////////////////////////////////
// Interpolate
// Finds a location between two points in 2D space
////////////////////////////////////////////////////////////////////////////////
VECTOR_2D interpolate2d(VECTOR_2D start, VECTOR_2D finish, float position)
{
   VECTOR_2D location;

   location.x = ((finish.x - start.x) * position) + start.x;
   location.y = ((finish.y - start.y) * position) + start.y;

   return location;
}

////////////////////////////////////////////////////////////////////////////////
// Interpolate
// Finds a location between two points in 3D space
////////////////////////////////////////////////////////////////////////////////
VECTOR_3D interpolate3d(VECTOR_3D start, VECTOR_3D finish, float position)
{
   VECTOR_3D location;

   location.x = ((finish.x - start.x) * position) + start.x;
   location.y = ((finish.y - start.y) * position) + start.y;
   location.z = ((finish.z - start.z) * position) + start.z;

   return location;
}

////////////////////////////////////////////////////////////////////////////////
// Sign
// Gives the sign of the number
////////////////////////////////////////////////////////////////////////////////
signed int sign(double number)
{
   if (number > 0) return 1;
   if (number < 0) return -1;
   return 0;
}

////////////////////////////////////////////////////////////////////////////////
// Ran
// Gives a random double between 0 and n
////////////////////////////////////////////////////////////////////////////////
double ran(double n)
{
    return ((double)rand() / (double)RAND_MAX) * n;
}

////////////////////////////////////////////////////////////////////////////////
// Error
// Displays an error message and exits
////////////////////////////////////////////////////////////////////////////////
void error(char *message, int returnValue)
{
   allegro_exit();

   allegro_message("Deity Error: %s\n", message);
//   fprintf(stderr, "\nERROR: %s\n", message);
   if ((strcmp(allegro_error, "") != 0) && (allegro_error != NULL)) {
//      fprintf(stderr, "Allegro: %s\n\n", allegro_error);
      allegro_message("Allegro Error: %s\n\n", allegro_error);
   }

   exit(returnValue);
}
