////////////////////////////////////////////////////////////////////////////////
// Deity - By Carl Olsson 2000
// main.h Main Program functions
////////////////////////////////////////////////////////////////////////////////

#ifndef _MAIN_H
#define _MAIN_H

// Headers
#include <allegro.h>
#include "gamedata.h"
#include "sprite.h"
#include "input.h"
#include "sprite.h"
#include "register.h"
#include "display.h"

extern int waterFrame;
extern int objectFrame;
extern RGB_MAP rgbToIndexMap;
extern COLOR_MAP lightMap;
extern COLOR_MAP transMap;

// Game Time
extern volatile int milliseconds;
extern volatile int seconds;
extern volatile int minutes;
extern volatile int hours;

// Frames
extern volatile int frame;
extern volatile long int frameTotal;
extern volatile int fps;

// Game Cycles
extern volatile int cycle;
extern volatile long int cycleTotal;
extern volatile int cps;

// Video
extern int videoMethod;
extern int videoDriver;
extern int videoW;
extern int videoH;
extern int videoVW;
extern int videoVH;
extern int videoDepth;

extern const int worldWorshipers;
extern const int worldTrees;

extern Register<SpriteSet> *spriteSetRegister;
extern Register<Anim> *animRegister;

#endif // _MAIN_H
