#ifndef _INTERFACE_H
#define _INTERFACE_H

#include "world.h"
#include "input.h"
#include "view.h"

class Application;

class Interface {
// Function members
public:
  Interface(Application *const _application, World *const _world) : input(), view(), world(NULL) {
      setApplication(_application);
      input.setInterface(this);
      view.setInterface(this);
      setWorld(_world);
   }
   Interface(Application *const _application) : input(), view(), world(NULL) {
//      Interface(_application, NULL);
      setApplication(_application);
      input.setInterface(this);
      view.setInterface(this);
   }
   World *getWorld(void) { return world; }
   void setWorld(World *const _world) { world = _world; }
   Application *getApplication(void) { return application; }
   void setApplication(Application *const _application) { application = _application; }
   
// Data members
public:
   Input input;
   View view;
private:
   World *world;
   Application *application;
};

#endif
