#include "globaldecsshare.h"

script_event_typ::script_event_typ() // defined in map.cpp, since that's where it's primarily used
  {
  target=0;
  xTile=yTile=0;
  cycles=0;
  }

script_typ::script_typ()
  {
  camCenterX=camCenterY=15;
  }

void script_typ::nextEvent()
  {
  int i=script_num;
  int targetNPC=map.active_npcs-scriptNPCs+se[i].target;
  int txTile;
  int tyTile;

  // here we wait until toWalk==0 so the character finishes on that spot
  if(se[i].type_flag!=SE_MOVE_TALK_OR_RETILE)
    {
    switch(se[i].type_flag)
      {
      case SE_REITEM:
        if(!key[KEY_SPACE])
          rest(1000);
        map.tiles[se[i].xTile][se[i].yTile].item=se[i].target;
        map.tiles[se[i].xTile][se[i].yTile].item_var=se[i].cycles;
        drawGameFrame(1); // fade!
        sound.playSound(SFX_LAUGH);
        if(!key[KEY_SPACE])
          rest(1000);
        se[i].cycles=-10;
        mapSave(map.world_level);
        break;
      case SE_LOADLEVEL: // Script Entity
        if(map.world_level!=5) // never permanently over write the REAL castle
          mapSave(map.world_level);
        map.loadLevelUseCoord(se[i].target);
        camera_x=camCenterX=(se[i].xTile<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
        camera_y=camCenterY=(se[i].yTile<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
        se[i].cycles=-10;
        break;
      }
    }
  else
    {
    int txTile=(npc[targetNPC].x)-(TILE_SIDE>>1);
    int tyTile=(npc[targetNPC].y)-(TILE_SIDE>>1);
    txTile>>=TILE_SIDE_SHIFT;
    tyTile>>=TILE_SIDE_SHIFT;

    if(se[i].cycles<0)
      {
      rest(400);
      map.tiles[se[i].xTile][se[i].yTile].updateType(se[i].target);
      drawGameFrame(1); // fade!
      rest(400);
      if(map.world_level!=5) // never permanently over write the REAL castle
        mapSave(map.world_level);
      }
    else if(se[i].xTile==-1 && se[i].yTile==-1) // dialog only
      {
      if(dialog.isAlive()==0)
        se[i].cycles=1;
      }
    else if(txTile==se[i].xTile && tyTile==se[i].yTile && npc[targetNPC].toWalk==0)
      {
      se[i].cycles=1;
      npc[targetNPC].lockToGrid();
      }
    else
      {
      if(txTile<se[i].xTile)
        npc[targetNPC].facing=RIGHT;
      else if(txTile>se[i].xTile)
        npc[targetNPC].facing=LEFT;
      else if(tyTile<se[i].yTile)
        npc[targetNPC].facing=DOWN;
      else if(tyTile>se[i].yTile)
        npc[targetNPC].facing=UP;
      if(npc[targetNPC].toWalk<=0)
        npc[targetNPC].toWalk=STEP_SIZE;
      npc[targetNPC].moveMe(0); // deny it normal AI code
      }
    }

  if(camera_x<camCenterX) camera_x++;
  if(camera_x>camCenterX) camera_x--;
  if(camera_y<camCenterY) camera_y++;
  if(camera_y>camCenterY) camera_y--;

  if(dialog.isEmpty() && --se[i].cycles<=0) // end of instruction
    {
    if(--script_num<=0) // end of script?
      {
      map.active_npcs-=scriptNPCs;
      scriptNPCs=0;
      script_num=0;
      if(map.world_level==6)
        dialog.Spawn(700,3);
      }
    else
      {
      i=script_num;
      if(se[i].xTile==-1 && se[i].yTile==-1) // dialog only
        {
        targetNPC=map.active_npcs-scriptNPCs+se[i].target;
        txTile=(npc[targetNPC].x)-(TILE_SIDE>>1);
        tyTile=(npc[targetNPC].y)-(TILE_SIDE>>1);
        txTile>>=TILE_SIDE_SHIFT;
        tyTile>>=TILE_SIDE_SHIFT;
        npc[targetNPC].lockToGrid();

        camCenterX=(txTile<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
        camCenterY=(tyTile<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
        dialog.Spawn(600,targetNPC);
        }
      }
    }
  }

void script_typ::openScript(int scriptNum)
  {
  char filename[30],fullname[30];
  char filenum[10];

  strcpy(filename,"data//script");
  itoa(scriptNum,filenum,10);
  strcat(filename,filenum);
  strcat(filename,".scp");
  set_config_file(filename);

  camera_x=camCenterX=(get_config_int("map","centerOnXtile",15)<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
  camera_y=camCenterY=(get_config_int("map","centerOnYtile",15)<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);

  scriptNPCs=0; // keep a count so when the script's over we can remove them
  for(int i=map.active_npcs;i<MAX_NPCS;i++) // made on top of current NPC set
    {
    strcpy(filename,"npc");
    itoa(scriptNPCs+1,filenum,10);
    strcat(filename,filenum);
    npc[i].mySprite=get_config_int(filename,"mySprite", -1);
    if(npc[i].mySprite==-1) break;
    npc[i].x=(get_config_int(filename,"mapXtile", 1)<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
    npc[i].y=(get_config_int(filename,"mapYtile", 1)<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
    npc[i].lockToGrid();

    for(int ii=0;ii<DIALOG_LINES;ii++)
      {
      strcpy(fullname,"myText");
      itoa(ii+1,filenum,10);
      strcat(fullname,filenum);
      strcpy(npc[i].line[ii],get_config_string(filename,fullname, ""));
      }

    map.active_npcs++;
    scriptNPCs++; // keep a count so when the script's over we can remove them
    }

  script_num=0;
  for(int i=0;i<MAX_SCRIPT_LENGTH;i++) // made on top of current NPC set
    {
    strcpy(filename,"frame");
    itoa(i+1,filenum,10);
    strcat(filename,filenum);

    if(get_config_int(filename,"myNpc", -1)==-1) break;
    script_num++;
    }

  for(int i=1;i<script_num+1;i++) // +1 because when script_num=0, script should be finished
    {
    strcpy(filename,"frame");
    itoa(script_num-i+1,filenum,10);
    strcat(filename,filenum);
    se[i].target=get_config_int(filename,"myNpc", -1)-1; // minus one to keep references to NPC's positive
    se[i].xTile=get_config_int(filename,"mapXtile", 1);
    se[i].yTile=get_config_int(filename,"mapYtile", 1);
    se[i].cycles=get_config_int(filename,"wait_cycles", 1);
    se[i].type_flag=get_config_int(filename,"type", SE_MOVE_TALK_OR_RETILE);
    if(se[i].type_flag!=SE_MOVE_TALK_OR_RETILE)
      se[i].target++; // 0-count anything but NPCs
    }
  }
