#include "globaldecsshare.h"

rps_typ::rps_typ()
  {
  for(int i=0;i<DIALOG_LINES;i++)
    strcpy(line[i],"!");
  lines_to_update=0;
  }

int rps_typ::play_rps()
  {
  int throw_rps=-1, enemy_throw, victory;
  char stringToCat[10];

  dialog.Handle();

  if(num_joysticks) poll_joystick();

  if((mode==RPS_WIZARD ? key[KEY_R] : key[KEY_E]) || (num_joysticks && joy[0].button[0].b)) throw_rps=THROW_ROCK;
  else if((mode==RPS_WIZARD ? key[KEY_P] : key[KEY_W]) || (num_joysticks && joy[0].button[1].b)) throw_rps=THROW_PAPER;
  else if((mode==RPS_WIZARD ? key[KEY_S] : key[KEY_L]) || (num_joysticks && joy[0].button[2].b)) throw_rps=THROW_SCISSORS;

  if(playerScore>=3 || bossScore>=3)
    if(key[KEY_W] || key[KEY_A] || key[KEY_S] || key[KEY_D] || key[KEY_SPACE] ||
       key[KEY_UP] || key[KEY_LEFT] || key[KEY_DOWN] || key[KEY_RIGHT])
       throw_rps=-2; // let someone quite with a non-playing key

  if(lines_to_update==0 && throw_rps!=-1)
    {
    if(playerScore>=3)
      return 1;
    else if(bossScore>=3)
      return -1;

    if(mode==RPS_WIZARD)
      enemy_throw=rand()%THROW_NUM;
    else
      {
      switch(human_inventory.wand) // magic, i.e. collecting rudich wands, is key
        {
        case 0: // always lose
          enemy_throw=(throw_rps+1)%THROW_NUM;
          break;
        case 1: // always fair game
          enemy_throw=rand()%THROW_NUM;
           break;
        case 2: // always win
          enemy_throw=throw_rps-1;
          if(enemy_throw<0) enemy_throw=THROW_NUM-1;
          break;
        }
      }

    switch(throw_rps)
      {
      case THROW_ROCK:
        if(mode==RPS_WIZARD)
          strcpy(line[0],"I throw Rock!");
        else
          strcpy(line[0],"The earth rises at my call!");
        switch(enemy_throw)
          {
          case THROW_ROCK:
            if(mode==RPS_WIZARD)
              {
              strcpy(line[1],"She throws Rock!");
              strcpy(line[2],"Rock bounces off rock!");
              }
            else
              {
              strcpy(line[1],"She summons the earth to her will!");
              strcpy(line[2],"Tides of earth crash!");
              }
            victory=0;
            break;
          case THROW_PAPER:
            if(mode==RPS_WIZARD)
              {
              strcpy(line[1],"She throws Paper!");
              strcpy(line[2],"Rock is covered by Paper!");
              }
            else
              {
              strcpy(line[1],"She brings forth Water!");
              strcpy(line[2],"Water washes away my earth!");
              }
            victory=-1;
            break;
          case THROW_SCISSORS:
            if(mode==RPS_WIZARD)
              {
              strcpy(line[1],"She throws Scissors!");
              strcpy(line[2],"Rock breaks Scissors!");
              }
            else
              {
              strcpy(line[1],"She summons Lightning!");
              strcpy(line[2],"Earth absorbs the charge and hits her!");
              }
            victory=1;
            break;
          }
        break;
      case THROW_PAPER:
        if(mode==RPS_WIZARD)
          strcpy(line[0],"I throw Paper!");
        else
          strcpy(line[0],"Water races forth at my gesture!");
        switch(enemy_throw)
          {
          case THROW_ROCK:
            if(mode==RPS_WIZARD)
              {
              strcpy(line[1],"She throws Rock!");
              strcpy(line[2],"Paper covers Rock!");
              }
            else
              {
              strcpy(line[1],"She sends forth a barrage of rocks!");
              strcpy(line[2],"Water sweeps the stones away!");
              }
            victory=1;
            break;
          case THROW_PAPER:
            if(mode==RPS_WIZARD)
              {
              strcpy(line[1],"She throws Paper!");
              strcpy(line[2],"Paper can't hurt paper!");
              }
            else
              {
              strcpy(line[1],"Waves rush toward you at her bidding!");
              strcpy(line[2],"Water mixes harmlessly with water!");
              }
            victory=0;
            break;
          case THROW_SCISSORS:
            if(mode==RPS_WIZARD)
              {
              strcpy(line[1],"She throws Scissors!");
              strcpy(line[2],"Paper is cut by Scissors!");
              }
            else
              {
              strcpy(line[1],"Lightning strikes from the heavens!");
              strcpy(line[2],"Water is vaporized by Lightning!");
              }
            victory=-1;
            break;
          }
        break;
      case THROW_SCISSORS:
        if(mode==RPS_WIZARD)
          strcpy(line[0],"I throw Scissors!");
        else
          strcpy(line[0],"Lightning rains down at my command!");
        switch(enemy_throw)
          {
          case THROW_ROCK:
            if(mode==RPS_WIZARD)
              {
              strcpy(line[1],"She throws Rock!");
              strcpy(line[2],"Scissors are broken by rock!");
              }
            else
              {
              strcpy(line[1],"The earth rumbles and rises toward you!");
              strcpy(line[2],"Lightning strikes uselessly on earth!");
              }
            victory=-1;
            break;
          case THROW_PAPER:
            if(mode==RPS_WIZARD)
              {
              strcpy(line[1],"She throws Paper!");
              strcpy(line[2],"Scissors cut Paper!");
              }
            else
              {
              strcpy(line[1],"Monsoon rains speed toward you!");
              strcpy(line[2],"Lightning shatters the clouds!");
              }
            victory=1;
            break;
          case THROW_SCISSORS:
            if(mode==RPS_WIZARD)
              {
              strcpy(line[1],"She throws Scissors!");
              strcpy(line[2],"Scissors can't cut Scissors!");
              }
            else
              {
              strcpy(line[1],"Lightning gathers at her fingertips!");
              strcpy(line[2],"Lightning cracks against lightning!");
              }

            victory=0;
            break;
          }
        break;
      }
    switch(victory)
      {
      case -1:
        bossScore++;
        strcpy(line[3],"She beat me! (");
        if(mode==RPS_WIZARD)
          sound.playSound(SFX_CRITICALHIT);
        else
          sound.playSound(SFX_FIRE2);
        break;
      case 0:
        strcpy(line[3],"It's a draw! (");
        if(mode==RPS_WIZARD)
          sound.playSound(SFX_HIT);
        else
          sound.playSound(SFX_WRONG);
        break;
      case 1:
        playerScore++;
        strcpy(line[3],"I beat her! (");
        if(mode==RPS_WIZARD)
          sound.playSound(SFX_STRIKE);
        else
          sound.playSound(SFX_CURE1);
        break;
      }
    itoa(playerScore,stringToCat,10);
    strcat(line[3],stringToCat);
    strcat(line[3]," to ");
    itoa(bossScore,stringToCat,10);
    strcat(line[3],stringToCat);
    strcat(line[3],")");
    if(playerScore>=3)
      {
      sound.playSound(SFX_WINBATTLE);
      if(mode==RPS_WIZARD)
        strcpy(line[4],"You won! But wait... her true form?!");
      else
        strcpy(line[4],"You really won! You saved Shiuliang!");
      }
    else if(bossScore>=3)
      {
      sound.playSound(SFX_EARTH);
      strcpy(line[4],"You are defeated... Begone!!");
      }
    else
      {
      if(mode==RPS_WIZARD)
        strcpy(line[4],"What's next?  R, P, or S?");
      else
        strcpy(line[4],"What's next?  E, L, or W?");
      }
    lines_to_update=DIALOG_LINES;

    dialog.scrolloffset=LETTER_HEIGHT;
    for(int i=0;i<DIALOG_LINES-1;i++)
        strcpy(dialog.line[i],dialog.line[i+1]);
      strcpy(dialog.line[DIALOG_LINES-1],line[DIALOG_LINES-lines_to_update]);

    rest(125); // pause
    }
  else if(lines_to_update>0)
    {
    if(dialog.scrolloffset-->=0)
      /*skip*/;
    else if(--lines_to_update>0)
      {
      dialog.scrolloffset=LETTER_HEIGHT;
      for(int i=0;i<DIALOG_LINES-1;i++)
        strcpy(dialog.line[i],dialog.line[i+1]);
      strcpy(dialog.line[DIALOG_LINES-1],line[DIALOG_LINES-lines_to_update]);
      }
    }
  return 0;
  }

void rps_typ::draw_rps()
  {
  draw_sprite(DB,BOSSDRAGON,0,0);
  dialog.drawMe();
  BMP2SCREENnoMOUSE(DB)
  rest(PROG_DELAY);
  }

void rps_typ::buildScreen()
  {
  BITMAP *scrap;
  int coltrap;
  PALETTE the_palette;

  if(mode==RPS_WIZARD)
    scrap = load_pcx("data//bosswizard.pcx",the_palette);
  else
    scrap = load_pcx("data//bossdragon.pcx",the_palette);
  BOSSDRAGON = create_bitmap(DB->w,DB->h);
  draw_sprite(rps.BOSSDRAGON,DB,0,0);
  for(int x=0;x<rps.BOSSDRAGON->w;x++) // fade to dark red
    for(int y=0;y<rps.BOSSDRAGON->h;y++)
      {
      coltrap=_getpixel16(DB,x,y);
      _putpixel16(rps.BOSSDRAGON,x,y,makecol16((getr16(coltrap))-(getr16(coltrap)>>2),
                                               (getg16(coltrap))>>2,
                                               (getb16(coltrap))>>2));
      }
  draw_sprite(rps.BOSSDRAGON,scrap,(rps.BOSSDRAGON->w-scrap->w)>>1,(rps.BOSSDRAGON->h-scrap->h)>>3);
  }

void rps_typ::rps_close()
  {
  destroy_bitmap(BOSSDRAGON);
  stop_sample(battle_wav);
  destroy_sample(battle_wav);
  LEVEL_SONG=load_midi("data//overworld.mid");
  play_midi(LEVEL_SONG,1);
  }

int rps_typ::main_rps(int nmode)
  {
  int gameon=1;
  char fullname[20],filenum[5];

  mode=nmode;

  playerScore=bossScore=0;

  /*strcpy(fullname,"data//level");
  itoa(map.world_level,filenum,10);
  strcat(fullname,filenum);
  strcat(fullname,".dat");
  set_config_file(fullname);*/
  buildScreen();

  for(int i=0;i<DIALOG_LINES;i++)
    {
    strcpy(fullname,"myText");
    itoa(i+1,filenum,10);
    strcat(fullname,filenum);
    strcpy(dialog.bossopening1[i],get_config_string("BossText",fullname, ""));
    strcpy(dialog.bossopening2[i],get_config_string("BossText2",fullname, ""));
    if(mode==RPS_WIZARD)
      strcpy(dialog.line[i],dialog.bossopening1[i]);
    else
      strcpy(dialog.line[i],dialog.bossopening2[i]);
    }

  dialog.Spawn(1000,TALK_TO_RPS);
  sound.playSound(SFX_LAUGH);
  destroy_midi(LEVEL_SONG);
  battle_wav = load_sample("data//battletheme.wav");
  play_sample(battle_wav, g_soundon, 500, 1000, TRUE);

  while(gameon)
    {
    switch(play_rps())
      {
      case -1: // he won
        rps_close();
        return -1;
        break;
      case 1: // I won
        rps_close();
        return 1;
        break;
      case 0: // default
        break;
      }
    draw_rps();
    if(key[KEY_ESC]) gameon=0;
    }
  rps_close();
  return 0;
  }
